"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlRenderer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _control_factory_registry = require("../../control_factory_registry");
var _control_panel = require("./control_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/control_group/components/control_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a component from the control registry into a Control Panel
 */
const ControlRenderer = ({
  type,
  uuid,
  getParentApi,
  onApiAvailable,
  isControlGroupInitialized
}) => {
  const [component, setComponent] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    let ignore = false;
    async function buildControl() {
      var _controlGroupApi$getS;
      const controlGroupApi = getParentApi();
      const factory = await (0, _control_factory_registry.getControlFactory)(type);
      const finalizeApi = apiRegistration => {
        return {
          ...apiRegistration,
          uuid,
          parentApi: controlGroupApi,
          type: factory.type
        };
      };
      const {
        rawState: initialState
      } = (_controlGroupApi$getS = controlGroupApi.getSerializedStateForChild(uuid)) !== null && _controlGroupApi$getS !== void 0 ? _controlGroupApi$getS : {
        rawState: {}
      };
      return await factory.buildControl({
        initialState: initialState,
        finalizeApi,
        uuid,
        controlGroupApi
      });
    }
    buildControl().then(({
      api,
      Component
    }) => {
      if (ignore) {
        return;
      }
      onApiAvailable === null || onApiAvailable === void 0 ? void 0 : onApiAvailable(api);
      setComponent(/*#__PURE__*/_react.default.forwardRef((props, ref) => {
        // expose the api into the imperative handle
        (0, _react.useImperativeHandle)(ref, () => api, []);
        return /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 22
          }
        }));
      }));
    }).catch(error => {
      if (ignore) {
        return;
      }
      /**
       * critical error encountered when trying to build the control;
       * since no API is available, create a dummy API that allows the control to be deleted
       * */
      const errorApi = {
        uuid,
        blockingError: new _rxjs.BehaviorSubject(error)
      };
      setComponent(/*#__PURE__*/_react.default.forwardRef((_, ref) => {
        // expose the dummy error api into the imperative handle
        (0, _react.useImperativeHandle)(ref, () => errorApi, []);
        return null;
      }));
    });
    return () => {
      ignore = true;
    };
  },
  /**
   * Disabling exhaustive deps because we do not want to re-fetch the component
   * unless the type changes.
   */
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [type]);
  return component && isControlGroupInitialized ?
  /*#__PURE__*/
  // @ts-expect-error
  _react.default.createElement(_control_panel.ControlPanel, {
    Component: component,
    uuid: uuid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 5
    }
  }) :
  // Control group will not display controls until all controls are initialized
  null;
};
exports.ControlRenderer = ControlRenderer;