"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VariablesEditor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _contexts = require("../../contexts");
var _variables_editor_form = require("./variables_editor_form");
var utils = _interopRequireWildcard(require("./utils"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/console/public/application/components/variables/variables_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sendToBrowserClipboard = async text => {
  var _window$navigator;
  if ((_window$navigator = window.navigator) !== null && _window$navigator !== void 0 && _window$navigator.clipboard) {
    await window.navigator.clipboard.writeText(text);
    return;
  }
  throw new Error('Could not copy to clipboard!');
};
const copyToClipboard = async (text, notifications) => {
  try {
    await sendToBrowserClipboard(text);
    notifications.toasts.addSuccess({
      title: _i18n.i18n.translate('console.variabllesPage.copyToClipboardSuccess', {
        defaultMessage: 'Variable name copied to clipboard'
      })
    });
  } catch (e) {
    notifications.toasts.addError(e, {
      title: _i18n.i18n.translate('console.variabllesPage.copyToClipboardFailed', {
        defaultMessage: 'Could not copy variable name to clipboard'
      })
    });
  }
};
const styles = {
  conVariablesTable: (0, _react2.css)`
    .euiTableRow-isExpandedRow .euiTableCellContent {
      padding: 0;
    }
  `
};
const VariablesEditor = props => {
  const isMounted = (0, _react.useRef)(false);
  const [isAddingVariable, setIsAddingVariable] = (0, _react.useState)(false);
  const [deleteModalForVariable, setDeleteModalForVariable] = (0, _react.useState)(null);
  const [variables, setVariables] = (0, _react.useState)(props.variables);
  const deleteModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    services: {
      notifications
    }
  } = (0, _contexts.useServicesContext)();

  // Use a ref to persist the BehaviorSubject across renders
  const itemIdToExpandedRowMap$ = (0, _react.useRef)(new _rxjs.BehaviorSubject({}));
  // Subscribe to the BehaviorSubject and update local state on change
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  // Clear the expanded row map and dispose all the expanded rows
  const collapseExpandedRows = () => itemIdToExpandedRowMap$.current.next({});

  // Subscribe to the BehaviorSubject on mount
  (0, _react.useEffect)(() => {
    const subscription = itemIdToExpandedRowMap$.current.subscribe(setItemIdToExpandedRowMap);
    return () => subscription.unsubscribe();
  }, []);

  // Always save variables when they change
  (0, _react.useEffect)(() => {
    if (isMounted.current) {
      props.onSaveVariables(variables);
    } else {
      isMounted.current = true;
    }
  }, [variables, props]);
  const toggleDetails = variableId => {
    const currentMap = itemIdToExpandedRowMap$.current.getValue();
    let itemIdToExpandedRowMapValues = {
      ...currentMap
    };
    if (itemIdToExpandedRowMapValues[variableId]) {
      delete itemIdToExpandedRowMapValues[variableId];
    } else {
      // Always close the add variable form when editing a variable
      setIsAddingVariable(false);
      // We only allow one expanded row at a time
      itemIdToExpandedRowMapValues = {};
      itemIdToExpandedRowMapValues[variableId] = /*#__PURE__*/_react.default.createElement(_variables_editor_form.VariableEditorForm, {
        title: _i18n.i18n.translate('console.variablesPage.editVariableForm.title', {
          defaultMessage: 'Edit variable'
        }),
        onSubmit: data => {
          const updatedVariables = utils.editVariable(data, variables);
          setVariables(updatedVariables);
          collapseExpandedRows();
        },
        onCancel: () => {
          collapseExpandedRows();
        },
        defaultValue: variables.find(v => v.id === variableId),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 9
        }
      });
    }

    // Update the BehaviorSubject with the new state
    itemIdToExpandedRowMap$.current.next(itemIdToExpandedRowMapValues);
  };
  const deleteVariable = (0, _react.useCallback)(id => {
    const updatedVariables = utils.deleteVariable(variables, id);
    setVariables(updatedVariables);
    setDeleteModalForVariable(null);
  }, [variables, setDeleteModalForVariable]);
  const onAddVariable = data => {
    setVariables(v => [...v, data]);
    setIsAddingVariable(false);
  };
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('console.variablesPage.variablesTable.columns.variableHeader', {
      defaultMessage: 'Variable name'
    }),
    'data-test-subj': 'variableNameCell',
    render: name => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 16
        }
      }, `\$\{${name}\}`);
    }
  }, {
    field: 'value',
    name: _i18n.i18n.translate('console.variablesPage.variablesTable.columns.valueHeader', {
      defaultMessage: 'Value'
    }),
    'data-test-subj': 'variableValueCell',
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 34
      }
    }, value)
  }, {
    field: 'id',
    name: '',
    width: '40px',
    render: (id, variable) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: _i18n.i18n.translate('console.variablesPage.copyVariableToClipboardTooltip', {
          defaultMessage: 'Copy variable name to clipboard'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "copy",
        "aria-label": _i18n.i18n.translate('console.variablesPage.variablesTable.columns.copyNameButton', {
          defaultMessage: 'Copy {variable} to clipboard',
          values: {
            variable: variable.name
          }
        }),
        color: "primary",
        onClick: () => copyToClipboard(`\$\{${variable.name}\}`, notifications),
        "data-test-subj": `variableCopyButton-${variable.name}`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 187,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'id',
    name: '',
    width: '40px',
    isExpander: true,
    render: (id, variable) => {
      const itemIdToExpandedRowMapValues = {
        ...itemIdToExpandedRowMap
      };
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: itemIdToExpandedRowMapValues[id] ? 'arrowUp' : 'pencil',
        "aria-label": _i18n.i18n.translate('console.variablesPage.variablesTable.columns.editButton', {
          defaultMessage: 'Edit {variable}',
          values: {
            variable: variable.name
          }
        }),
        color: "primary",
        onClick: () => toggleDetails(id),
        "data-test-subj": "variableEditButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 213,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'id',
    name: '',
    width: '40px',
    render: (id, variable) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('console.variablesPage.variablesTable.columns.deleteButton', {
        defaultMessage: 'Delete {variable}',
        values: {
          variable: variable.name
        }
      }),
      color: "danger",
      onClick: () => setDeleteModalForVariable(id),
      "data-test-subj": "variablesRemoveButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 9
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.pageTitle",
    defaultMessage: "Variables",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.pageDescription",
    defaultMessage: "Define reusable placeholders for dynamic values in your queries.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: variables,
    columns: columns,
    itemId: "id",
    responsiveBreakpoint: false,
    css: styles.conVariablesTable,
    "data-test-subj": "variablesTable",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    noItemsMessage: _i18n.i18n.translate('console.variablesPage.table.noItemsMessage', {
      defaultMessage: 'No variables have been added yet'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 7
    }
  }), isAddingVariable && /*#__PURE__*/_react.default.createElement(_variables_editor_form.VariableEditorForm, {
    onSubmit: onAddVariable,
    onCancel: () => setIsAddingVariable(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "variablesAddButton",
    iconType: "plusInCircle",
    onClick: () => {
      setIsAddingVariable(true);
      collapseExpandedRows();
    },
    disabled: isAddingVariable,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.addButtonLabel",
    defaultMessage: "Add variable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 292,
      columnNumber: 11
    }
  }))), deleteModalForVariable && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": deleteModalTitleId,
    title: _i18n.i18n.translate('console.variablesPage.deleteModal.title', {
      defaultMessage: 'Are you sure?'
    }),
    onCancel: () => setDeleteModalForVariable(null),
    onConfirm: () => deleteVariable(deleteModalForVariable),
    cancelButtonText: _i18n.i18n.translate('console.variablesPage.deleteModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('console.variablesPage.deleteModal.confirmButtonText', {
      defaultMessage: 'Delete variable'
    }),
    buttonColor: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "console.variablesPage.deleteModal.description",
    defaultMessage: "Deleting a variable is irreversible.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 13
    }
  }))));
};
exports.VariablesEditor = VariablesEditor;