"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KspmEksInputSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/fleet_extensions/cnvm_kspm/kspm_eks_input_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const KspmEksInputSelector = ({
  input,
  disabled,
  setInput
}) => {
  const baseOptions = (0, _utils.getPolicyTemplateInputOptions)(input.policy_template);
  const options = baseOptions ? baseOptions.map(option => ({
    ...option,
    disabled: option.disabled || disabled,
    label: option.label,
    icon: option.icon
  })) : [];
  return /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.RadioGroup, {
    disabled: disabled,
    idSelected: input.type,
    options: options,
    onChange: inputType => setInput(inputType),
    size: "m",
    name: "kspmEksInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
exports.KspmEksInputSelector = KspmEksInputSelector;