"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCommonUpdateUserActionBuilder = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _domain = require("../../../common/types/domain");
var _timestamp = require("./timestamp");
var _copy_link = require("./copy_link");
var _move_to_reference = require("./move_to_reference");
var _hoverable_user_with_avatar_resolver = require("../user_profiles/hoverable_user_with_avatar_resolver");
var _user_actions_aria_labels = require("./user_actions_aria_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const showMoveToReference = (action, commentId) => action === _domain.UserActionActions.update && commentId != null;
const CommentListActions = /*#__PURE__*/_react.default.memo(({
  userAction,
  handleOutlineComment
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  responsive: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 33,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
  id: userAction.id,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 35,
    columnNumber: 7
  }
})), showMoveToReference(userAction.action, userAction.commentId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_move_to_reference.UserActionMoveToReference, {
  id: userAction.commentId,
  outlineComment: handleOutlineComment,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 9
  }
}))));
CommentListActions.displayName = 'CommentListActions';
const createCommonUpdateUserActionBuilder = ({
  userProfiles,
  userAction,
  label,
  icon,
  handleOutlineComment
}) => {
  return {
    build: () => [{
      username: /*#__PURE__*/_react.default.createElement(_hoverable_user_with_avatar_resolver.HoverableUserWithAvatarResolver, {
        user: userAction.createdBy,
        userProfiles: userProfiles,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 11
        }
      }),
      event: label,
      'data-test-subj': `${userAction.type}-${userAction.action}-action-${userAction.id}`,
      timestamp: /*#__PURE__*/_react.default.createElement(_timestamp.UserActionTimestamp, {
        createdAt: userAction.createdAt,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 20
        }
      }),
      timelineAvatar: icon,
      timelineAvatarAriaLabel: (0, _user_actions_aria_labels.getUserActionAriaLabel)(userAction.type),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_copy_link.UserActionCopyLink, {
        id: userAction.id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 15
        }
      })), showMoveToReference(userAction.action, userAction.commentId) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_move_to_reference.UserActionMoveToReference, {
        id: userAction.commentId,
        outlineComment: handleOutlineComment,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 17
        }
      })))
    }]
  };
};
exports.createCommonUpdateUserActionBuilder = createCommonUpdateUserActionBuilder;