"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSimilarCasesColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _status = require("@kbn/cases-components/src/status/status");
var _empty_value = require("../empty_value");
var _links = require("../links");
var _truncated_text = require("../truncated_text");
var _config = require("../severity/config");
var _use_cases_columns_configuration = require("../all_cases/use_cases_columns_configuration");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/similar_cases/use_similar_cases_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LINE_CLAMP = 3;
const getLineClampedCss = (0, _react2.css)`
  text-overflow: ellipsis;
  display: -webkit-box;
  -webkit-line-clamp: ${LINE_CLAMP};
  -webkit-box-orient: vertical;
  overflow: hidden;
  word-break: normal;
`;
const SIMILARITIES_FIELD = 'similarities';
const useSimilarCasesColumns = () => {
  const casesColumnsConfig = (0, _use_cases_columns_configuration.useCasesColumnsConfiguration)(false);
  const columns = (0, _react.useMemo)(() => [{
    field: casesColumnsConfig.title.field,
    name: casesColumnsConfig.title.name,
    sortable: false,
    render: (_title, theCase) => {
      if (theCase.id != null && theCase.title != null) {
        const caseDetailsLinkComponent = /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
          detailName: theCase.id,
          title: theCase.title,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 60,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_truncated_text.TruncatedText, {
          text: theCase.title,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 61,
            columnNumber: 17
          }
        }));
        return caseDetailsLinkComponent;
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '20%'
  }, {
    field: casesColumnsConfig.tags.field,
    name: casesColumnsConfig.tags.name,
    render: tags => {
      if (tags != null && tags.length > 0) {
        const clampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
          "data-test-subj": "similar-cases-table-column-tags",
          css: getLineClampedCss,
          gutterSize: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 77,
            columnNumber: 15
          }
        }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          css: (0, _react2.css)`
                      max-width: 100px;
                    `,
          color: "hollow",
          key: `${tag}-${i}`,
          "data-test-subj": `similar-cases-table-column-tags-${tag}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 19
          }
        }, tag)));
        const unclampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
          "data-test-subj": "similar-cases-table-column-tags",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 15
          }
        }, tags.map((tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          key: `${tag}-${i}`,
          "data-test-subj": `similar-cases-table-column-tags-${tag}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 100,
            columnNumber: 19
          }
        }, tag)));
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          "data-test-subj": "similar-cases-table-column-tags-tooltip",
          position: "left",
          content: unclampedBadges,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 15
          }
        }, clampedBadges);
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '12%'
  }, {
    field: casesColumnsConfig.category.field,
    name: casesColumnsConfig.category.name,
    sortable: false,
    render: category => {
      if (category != null) {
        return /*#__PURE__*/_react.default.createElement("span", {
          "data-test-subj": `similar-cases-table-column-category-${category}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 15
          }
        }, category);
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '120px'
  }, {
    field: casesColumnsConfig.status.field,
    name: casesColumnsConfig.status.name,
    sortable: false,
    render: status => {
      if (status != null) {
        return /*#__PURE__*/_react.default.createElement(_status.Status, {
          status: status,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 147,
            columnNumber: 20
          }
        });
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '110px'
  }, {
    field: casesColumnsConfig.severity.field,
    name: casesColumnsConfig.severity.name,
    sortable: false,
    render: severity => {
      if (severity != null) {
        return /*#__PURE__*/_react.default.createElement(_config.SeverityHealth, {
          "data-test-subj": `similar-cases-table-column-severity-${severity}`,
          severity: severity,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 161,
            columnNumber: 15
          }
        });
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '90px'
  }, {
    field: SIMILARITIES_FIELD,
    name: i18n.SIMILARITY_REASON,
    sortable: false,
    render: similarities => {
      const similarObservableValues = similarities.observables.map(similarity => `${similarity.typeLabel}:${similarity.value}`);
      if (similarObservableValues.length > 0) {
        const clampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
          "data-test-subj": "similar-cases-table-column-similarities",
          css: getLineClampedCss,
          gutterSize: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 182,
            columnNumber: 15
          }
        }, similarObservableValues.map(similarValue => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          css: (0, _react2.css)`
                      max-width: 100px;
                    `,
          color: "hollow",
          key: `${similarValue}`,
          "data-test-subj": `similar-cases-table-column-similarities-${similarValue}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 19
          }
        }, similarValue)));
        const unclampedBadges = /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
          "data-test-subj": "similar-cases-table-column-similarities",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 203,
            columnNumber: 15
          }
        }, similarObservableValues.map(similarValue => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
          color: "hollow",
          key: `${similarValue}`,
          "data-test-subj": `similar-cases-table-column-similarities-${similarValue}`,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 205,
            columnNumber: 19
          }
        }, similarValue)));
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          "data-test-subj": "similar-cases-table-column-similarities-tooltip",
          position: "left",
          content: unclampedBadges,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 217,
            columnNumber: 15
          }
        }, clampedBadges);
      }
      return (0, _empty_value.getEmptyCellValue)();
    },
    width: '20%'
  }], [casesColumnsConfig.category.field, casesColumnsConfig.category.name, casesColumnsConfig.severity.field, casesColumnsConfig.severity.name, casesColumnsConfig.status.field, casesColumnsConfig.status.name, casesColumnsConfig.tags.field, casesColumnsConfig.tags.name, casesColumnsConfig.title.field, casesColumnsConfig.title.name]);
  return {
    columns,
    rowHeader: casesColumnsConfig.title.field
  };
};
exports.useSimilarCasesColumns = useSimilarCasesColumns;