"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInitialCasesContextState = exports.casesContextReducer = exports.CasesContextStoreActionsList = void 0;
var _std = require("@kbn/std");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialCasesContextState = () => {
  return {
    createCaseFlyout: {
      isFlyoutOpen: false
    },
    selectCaseModal: {
      isModalOpen: false
    }
  };
};
exports.getInitialCasesContextState = getInitialCasesContextState;
let CasesContextStoreActionsList = exports.CasesContextStoreActionsList = /*#__PURE__*/function (CasesContextStoreActionsList) {
  CasesContextStoreActionsList[CasesContextStoreActionsList["OPEN_CREATE_CASE_FLYOUT"] = 0] = "OPEN_CREATE_CASE_FLYOUT";
  CasesContextStoreActionsList[CasesContextStoreActionsList["CLOSE_CREATE_CASE_FLYOUT"] = 1] = "CLOSE_CREATE_CASE_FLYOUT";
  CasesContextStoreActionsList[CasesContextStoreActionsList["OPEN_ADD_TO_CASE_MODAL"] = 2] = "OPEN_ADD_TO_CASE_MODAL";
  CasesContextStoreActionsList[CasesContextStoreActionsList["CLOSE_ADD_TO_CASE_MODAL"] = 3] = "CLOSE_ADD_TO_CASE_MODAL";
  return CasesContextStoreActionsList;
}({});
const casesContextReducer = (state, action) => {
  switch (action.type) {
    case CasesContextStoreActionsList.OPEN_CREATE_CASE_FLYOUT:
      {
        return {
          ...state,
          createCaseFlyout: {
            isFlyoutOpen: true,
            props: action.payload
          }
        };
      }
    case CasesContextStoreActionsList.CLOSE_CREATE_CASE_FLYOUT:
      {
        return {
          ...state,
          createCaseFlyout: {
            isFlyoutOpen: false
          }
        };
      }
    case CasesContextStoreActionsList.OPEN_ADD_TO_CASE_MODAL:
      {
        return {
          ...state,
          selectCaseModal: {
            isModalOpen: true,
            props: action.payload
          }
        };
      }
    case CasesContextStoreActionsList.CLOSE_ADD_TO_CASE_MODAL:
      {
        return {
          ...state,
          selectCaseModal: {
            isModalOpen: false
          }
        };
      }
    default:
      (0, _std.assertNever)(action);
  }
};
exports.casesContextReducer = casesContextReducer;