"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_delete_action = require("../actions/delete/use_delete_action");
var _use_severity_action = require("../actions/severity/use_severity_action");
var _use_status_action = require("../actions/status/use_status_action");
var _edit_tags_flyout = require("../actions/tags/edit_tags_flyout");
var _use_tags_action = require("../actions/tags/use_tags_action");
var _confirm_delete_case = require("../confirm_delete_case");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_assignees_action = require("../actions/assignees/use_assignees_action");
var _edit_assignees_flyout = require("../actions/assignees/edit_assignees_flyout");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/use_bulk_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useBulkActions = ({
  selectedCases,
  onAction,
  onActionSuccess
}) => {
  const isDisabled = selectedCases.length === 0;
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const deleteAction = (0, _use_delete_action.useDeleteAction)({
    isDisabled,
    onAction,
    onActionSuccess
  });
  const statusAction = (0, _use_status_action.useStatusAction)({
    isDisabled,
    onAction,
    onActionSuccess
  });
  const severityAction = (0, _use_severity_action.useSeverityAction)({
    isDisabled,
    onAction,
    onActionSuccess
  });
  const tagsAction = (0, _use_tags_action.useTagsAction)({
    isDisabled,
    onAction,
    onActionSuccess
  });
  const assigneesAction = (0, _use_assignees_action.useAssigneesAction)({
    isDisabled: false,
    onAction,
    onActionSuccess
  });
  const canDelete = deleteAction.canDelete;
  const canUpdate = statusAction.canUpdateStatus;
  const canAssign = permissions.assign;
  const panels = (0, _react.useMemo)(() => {
    const mainPanelItems = [];
    if (canUpdate) {
      mainPanelItems.push({
        name: i18n.STATUS,
        panel: 1,
        disabled: isDisabled,
        'data-test-subj': 'case-bulk-action-status',
        key: 'case-bulk-action-status'
      });
      mainPanelItems.push({
        name: i18n.SEVERITY,
        panel: 2,
        disabled: isDisabled,
        'data-test-subj': 'case-bulk-action-severity',
        key: 'case-bulk-action-severity'
      });
    }

    /**
     * A separator is added if a) there is one item above
     * and b) there is an item below. For this to happen the
     * user has to have delete and update permissions
     */
    if (canUpdate && canDelete) {
      mainPanelItems.push({
        isSeparator: true,
        key: 'bulk-actions-separator',
        'data-test-subj': 'bulk-actions-separator'
      });
    }
    if (canUpdate) {
      mainPanelItems.push(tagsAction.getAction(selectedCases));
    }
    if (canAssign) {
      mainPanelItems.push(assigneesAction.getAction(selectedCases));
    }
    if (canDelete) {
      mainPanelItems.push(deleteAction.getAction(selectedCases));
    }
    const panelsToBuild = [{
      id: 0,
      items: [...mainPanelItems],
      // Create a new array instead of using reference
      title: i18n.ACTIONS
    }];
    if (canUpdate) {
      panelsToBuild.push({
        id: 1,
        title: i18n.STATUS,
        items: statusAction.getActions(selectedCases)
      });
      panelsToBuild.push({
        id: 2,
        title: i18n.SEVERITY,
        items: severityAction.getActions(selectedCases)
      });
    }
    return panelsToBuild;
  }, [canDelete, canUpdate, canAssign, deleteAction, isDisabled, selectedCases, severityAction, statusAction, tagsAction, assigneesAction]);
  return {
    modals: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, deleteAction.isModalVisible ? /*#__PURE__*/_react.default.createElement(_confirm_delete_case.ConfirmDeleteCaseModal, {
      totalCasesToBeDeleted: selectedCases.length,
      onCancel: deleteAction.onCloseModal,
      onConfirm: deleteAction.onConfirmDeletion,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }) : null),
    flyouts: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, tagsAction.isFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_edit_tags_flyout.EditTagsFlyout, {
      onClose: tagsAction.onFlyoutClosed,
      selectedCases: selectedCases,
      onSaveTags: tagsAction.onSaveTags,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 11
      }
    }) : null, assigneesAction.isFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_edit_assignees_flyout.EditAssigneesFlyout, {
      onClose: assigneesAction.onFlyoutClosed,
      selectedCases: selectedCases,
      onSaveAssignees: assigneesAction.onSaveAssignees,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }) : null),
    panels
  };
};
exports.useBulkActions = useBulkActions;