"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SidebarContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sidebar_header = require("../../sidebar_header");
var _multi_element_settings = require("../multi_element_settings");
var _group_settings = require("../group_settings");
var _global_config = require("../global_config");
var _element_settings = require("../element_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/sidebar/sidebar_content/sidebar_content.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getGroupedElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.groupedElementSidebarTitle', {
    defaultMessage: 'Grouped element',
    description: 'The title displayed when a grouped element is selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad. These elements can be grouped into a larger "grouped element" ' + 'that contains multiple individual elements.'
  }),
  getMultiElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.multiElementSidebarTitle', {
    defaultMessage: 'Multiple elements',
    description: 'The title displayed when multiple elements are selected. "elements" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  }),
  getSingleElementSidebarTitle: () => _i18n.i18n.translate('xpack.canvas.sidebarContent.singleElementSidebarTitle', {
    defaultMessage: 'Selected element',
    description: 'The title displayed when a single element are selected. "element" refer to the different visualizations, images, ' + 'text, etc that can be added in a Canvas workpad.'
  })
};
const MultiElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getMultiElementSidebarTitle(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 50,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_multi_element_settings.MultiElementSettings, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 52,
    columnNumber: 5
  }
}));
const GroupedElementSidebar = () => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getGroupedElementSidebarTitle(),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 58,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 59,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_group_settings.GroupSettings, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 5
  }
}));
const SingleElementSidebar = ({
  selectedElementId
}) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sidebar_header.SidebarHeader, {
  title: strings.getSingleElementSidebarTitle(),
  showLayerControls: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_element_settings.ElementSettings, {
  selectedElementId: selectedElementId,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 5
  }
}));
const SidebarContent = ({
  selectedToplevelNodes,
  selectedElementId
}) => {
  if (selectedToplevelNodes.length > 1) {
    return /*#__PURE__*/_react.default.createElement(MultiElementSidebar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 12
      }
    });
  }
  if (selectedToplevelNodes.length === 1 && selectedToplevelNodes[0].includes('group')) {
    return /*#__PURE__*/_react.default.createElement(GroupedElementSidebar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 12
      }
    });
  }
  if (selectedToplevelNodes.length === 1) {
    return /*#__PURE__*/_react.default.createElement(SingleElementSidebar, {
      selectedElementId: selectedElementId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_global_config.GlobalConfig, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 10
    }
  });
};
exports.SidebarContent = SidebarContent;