"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetManager = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../common/lib/constants");
var _loading = require("../loading");
var _asset = require("./asset");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/asset_manager/asset_manager.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getDescription: () => _i18n.i18n.translate('xpack.canvas.assetModal.modalDescription', {
    defaultMessage: 'Below are the image assets in this workpad. Any assets that are currently in use cannot be determined at this time. To reclaim space, delete assets.'
  }),
  getEmptyAssetsDescription: () => _i18n.i18n.translate('xpack.canvas.assetModal.emptyAssetsDescription', {
    defaultMessage: 'Import your assets to get started'
  }),
  getFilePickerPromptText: () => _i18n.i18n.translate('xpack.canvas.assetModal.filePickerPromptText', {
    defaultMessage: 'Select or drag and drop images'
  }),
  getLoadingText: () => _i18n.i18n.translate('xpack.canvas.assetModal.loadingText', {
    defaultMessage: 'Uploading images'
  }),
  getModalCloseButtonLabel: () => _i18n.i18n.translate('xpack.canvas.assetModal.modalCloseButtonLabel', {
    defaultMessage: 'Close'
  }),
  getModalTitle: () => _i18n.i18n.translate('xpack.canvas.assetModal.modalTitle', {
    defaultMessage: 'Manage workpad assets'
  }),
  getSpaceUsedText: percentageUsed => _i18n.i18n.translate('xpack.canvas.assetModal.spacedUsedText', {
    defaultMessage: '{percentageUsed}% space used',
    values: {
      percentageUsed
    }
  })
};
const AssetManager = props => {
  const {
    assets,
    onClose,
    onAddAsset
  } = props;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const assetsTotal = Math.round(assets.reduce((total, {
    value
  }) => total + value.length, 0) / 1024);
  const percentageUsed = Math.round(assetsTotal / _constants.ASSET_MAX_SIZE * 100);
  const emptyAssets = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    className: "canvasAssetManager__emptyPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "importAction",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 16
      }
    }, strings.getEmptyAssetsDescription()),
    titleSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
  const onFileUpload = files => {
    if (files === null) {
      return;
    }
    setIsLoading(true);
    Promise.all(Array.from(files).map(file => onAddAsset(file))).finally(() => {
      setIsLoading(false);
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: () => onClose(),
    className: "canvasAssetManager canvasModal--fixedSize",
    maxWidth: "1000px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    className: "canvasAssetManager__modalHeader",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    className: "canvasAssetManager__modalHeaderTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }, strings.getModalTitle()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasAssetManager__fileUploadWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_loading.Loading, {
    animated: true,
    text: strings.getLoadingText(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    initialPromptText: strings.getFilePickerPromptText(),
    compressed: true,
    display: "default",
    multiple: true,
    onChange: onFileUpload,
    accept: "image/*",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, strings.getDescription())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }), assets.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, assets.map(asset => /*#__PURE__*/_react.default.createElement(_asset.Asset, {
    asset: asset,
    key: asset.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }))) : emptyAssets), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    className: "canvasAssetManager__modalFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "canvasAssetManager__meterWrapper",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    value: assetsTotal,
    max: _constants.ASSET_MAX_SIZE,
    color: percentageUsed < 90 ? 'success' : 'danger',
    size: "s",
    "aria-labelledby": "CanvasAssetManagerLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    id: "CanvasAssetManagerLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 13
    }
  }, strings.getSpaceUsedText(percentageUsed)))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: () => onClose(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, strings.getModalCloseButtonLabel())));
};
exports.AssetManager = AssetManager;
AssetManager.propTypes = {
  assets: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  onClose: _propTypes.default.func.isRequired,
  onAddAsset: _propTypes.default.func.isRequired
};