"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.APM_APP_LOCATOR_ID = exports.APMServiceDetailLocator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _environment_filter_values = require("../../common/environment_filter_values");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const APM_APP_LOCATOR_ID = exports.APM_APP_LOCATOR_ID = 'APM_LOCATOR';
class APMServiceDetailLocator {
  constructor(uiSettings) {
    (0, _defineProperty2.default)(this, "id", APM_APP_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    this.uiSettings = uiSettings;
  }
  async getLocation(payload) {
    const {
      getPathForServiceDetail
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./helpers')));
    const defaultTimeRange = this.uiSettings.get(_public.UI_SETTINGS.TIMEPICKER_TIME_DEFAULTS);
    const isComparisonEnabledByDefault = this.uiSettings.get(_common.enableComparisonByDefault);
    const defaultEnvironment = this.uiSettings.get(_common.defaultApmServiceEnvironment, _environment_filter_values.ENVIRONMENT_ALL.value);
    const path = getPathForServiceDetail(payload, {
      ...defaultTimeRange,
      isComparisonEnabledByDefault,
      defaultEnvironment
    });
    return {
      app: 'apm',
      path,
      state: {}
    };
  }
}
exports.APMServiceDetailLocator = APMServiceDetailLocator;