"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dependencies = exports.DependenciesInventoryTitle = void 0;
var _i18n = require("@kbn/i18n");
var _ioTsUtils = require("@kbn/io-ts-utils");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var t = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _queryString = _interopRequireDefault(require("query-string"));
var _page_template = require("./page_template");
var _comparison_rt = require("../../../../common/comparison_rt");
var _dependency_detail_operations = require("../../app/dependency_detail_operations");
var _dependency_detail_overview = require("../../app/dependency_detail_overview");
var _dependency_detail_view = require("../../app/dependency_detail_view");
var _dependencies_inventory = require("../../app/dependencies_inventory");
var _dependency_operation_detail_view = require("../../app/dependency_operation_detail_view");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _transaction_tabs = require("../../app/transaction_details/waterfall_with_summary/transaction_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/home/dependencies.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DependenciesInventoryTitle = exports.DependenciesInventoryTitle = _i18n.i18n.translate('xpack.apm.views.dependenciesInventory.title', {
  defaultMessage: 'Dependencies'
});
function RedirectDependenciesToDependenciesOverview() {
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/dependencies');
  const search = _queryString.default.stringify(query);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: {
      pathname: `/dependencies/overview`,
      search
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 10
    }
  });
}
const dependencies = exports.dependencies = {
  ...(0, _page_template.page)({
    path: '/dependencies/inventory',
    title: DependenciesInventoryTitle,
    element: /*#__PURE__*/_react.default.createElement(_dependencies_inventory.DependenciesInventory, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 14
      }
    }),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt
      }), _comparison_rt.offsetRt])
    })
  }),
  '/dependencies': {
    element: /*#__PURE__*/_react.default.createElement(_dependency_detail_view.DependencyDetailView, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.Outlet, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    })),
    params: t.partial({
      query: t.intersection([t.type({
        comparisonEnabled: _ioTsUtils.toBooleanRt,
        dependencyName: t.string
      }), _comparison_rt.offsetRt])
    }),
    children: {
      '/dependencies': {
        element: /*#__PURE__*/_react.default.createElement(RedirectDependenciesToDependenciesOverview, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 67,
            columnNumber: 18
          }
        })
      },
      '/dependencies/operations': {
        element: /*#__PURE__*/_react.default.createElement(_dependency_detail_operations.DependencyDetailOperations, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 70,
            columnNumber: 18
          }
        })
      },
      '/dependencies/operation': {
        params: t.type({
          query: t.intersection([t.type({
            spanName: t.string,
            detailTab: t.union([t.literal(_transaction_tabs.TransactionTab.timeline), t.literal(_transaction_tabs.TransactionTab.metadata), t.literal(_transaction_tabs.TransactionTab.logs)]),
            showCriticalPath: _ioTsUtils.toBooleanRt
          }), t.partial({
            spanId: t.string,
            sampleRangeFrom: _ioTsUtils.toNumberRt,
            sampleRangeTo: _ioTsUtils.toNumberRt,
            waterfallItemId: t.string,
            flyoutDetailTab: t.string
          })])
        }),
        defaults: {
          query: {
            detailTab: _transaction_tabs.TransactionTab.timeline,
            showCriticalPath: ''
          }
        },
        element: /*#__PURE__*/_react.default.createElement(_dependency_operation_detail_view.DependencyOperationDetailView, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 18
          }
        })
      },
      '/dependencies/overview': {
        element: /*#__PURE__*/_react.default.createElement(_dependency_detail_overview.DependencyDetailOverview, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 102,
            columnNumber: 18
          }
        })
      }
    }
  }
};