"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmSwitchModal = ConfirmSwitchModal;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _elastic_docs_link = require("../../../shared/links/elastic_docs_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/schema/confirm_switch_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ConfirmSwitchModal({
  onConfirm,
  onCancel,
  unsupportedConfigs
}) {
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const [isConfirmChecked, setIsConfirmChecked] = (0, _react.useState)(false);
  const hasUnsupportedConfigs = !!unsupportedConfigs.length;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.title', {
      defaultMessage: 'Please confirm your choice'
    }),
    titleProps: {
      id: modalTitleId
    },
    cancelButtonText: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.cancelText', {
      defaultMessage: 'Cancel'
    }),
    onCancel: onCancel,
    confirmButtonText: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.switchButtonText', {
      defaultMessage: 'Switch to Elastic Agent'
    }),
    defaultFocusedButton: "confirm",
    onConfirm: () => {
      trackApmEvent({
        metric: 'confirm_data_stream_switch'
      });
      onConfirm();
    },
    confirmButtonDisabled: !isConfirmChecked,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, !hasUnsupportedConfigs && /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.unsupportedConfigs.descriptionText', {
    defaultMessage: `Compatible custom apm-server.yml user settings will be moved to Fleet Server settings for you. We'll let you know which settings are incompatible before removing them.`
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.irreversibleWarning.title', {
      defaultMessage: `Switching to Elastic Agent is an irreversible action`
    }),
    color: "warning",
    iconType: "question",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.irreversibleWarning.message', {
    defaultMessage: `It might temporarily affect your APM data collection while the migration is in progress. The process of migrating should only take a few minutes.`
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), hasUnsupportedConfigs && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.unsupportedConfigs.title', {
      defaultMessage: `The following apm-server.yml user settings are incompatible and will be removed`
    }),
    iconType: "info",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "yaml",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }, unsupportedConfigs.map(({
    key,
    value
  }) => `${key}: ${JSON.stringify(value)}`).join('\n')), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_elastic_docs_link.ElasticDocsLink, {
    section: "/cloud",
    path: "/ec-manage-apm-settings.html",
    target: "_blank",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.settings.schema.confirm.apmServerSettingsCloudLinkText', {
    defaultMessage: 'Go to APM Server settings in Cloud'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: (0, _eui.htmlIdGenerator)()(),
    label: _i18n.i18n.translate('xpack.apm.settings.schema.confirm.checkboxLabel', {
      defaultMessage: `I confirm that I wish to switch to Elastic Agent`
    }),
    checked: isConfirmChecked,
    onChange: e => {
      setIsConfirmChecked(e.target.checked);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  })));
}