"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileServiceOverview = MobileServiceOverview;
exports.chartHeight = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _annotations_context = require("../../../../context/annotations/annotations_context");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_time_range = require("../../../../hooks/use_time_range");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _service_overview_throughput_chart = require("../../service_overview/service_overview_throughput_chart");
var _transactions_table = require("../../../shared/transactions_table");
var _most_used_charts = require("./most_used_charts");
var _geo_map = require("./geo_map");
var _agent_name = require("../../../../../common/agent_name");
var _failed_transaction_rate_chart = require("../../../shared/charts/failed_transaction_rate_chart");
var _service_overview_dependencies_table = require("../../service_overview/service_overview_dependencies_table");
var _latency_chart = require("../../../shared/charts/latency_chart");
var _use_filters_for_embeddable_charts = require("../../../../hooks/use_filters_for_embeddable_charts");
var _get_kuery_with_mobile_filters = require("../../../../../common/utils/get_kuery_with_mobile_filters");
var _stats = require("./stats/stats");
var _location_stats = require("./stats/location_stats");
var _use_adhoc_apm_data_view = require("../../../../hooks/use_adhoc_apm_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/service_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * The height a chart should be if it's next to a table with 5 rows and a title.
 * Add the height of the pagination row.
 */
const chartHeight = exports.chartHeight = 288;
function MobileServiceOverview() {
  const {
    serviceName,
    agentName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    dataView
  } = (0, _use_adhoc_apm_data_view.useAdHocApmDataView)();
  const isAndroidAgent = (0, _agent_name.isAndroidAgentName)(agentName);
  const {
    query,
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo,
      device,
      osVersion,
      appVersion,
      netConnectionType,
      offset,
      comparisonEnabled,
      transactionType
    }
  } = (0, _use_apm_params.useApmParams)('/mobile-services/{serviceName}/overview');
  const embeddableFilters = (0, _use_filters_for_embeddable_charts.useFiltersForEmbeddableCharts)({
    serviceName,
    environment
  });
  const kueryWithMobileFilters = (0, _get_kuery_with_mobile_filters.getKueryWithMobileFilters)({
    device,
    osVersion,
    appVersion,
    netConnectionType,
    kuery
  });
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const dependenciesLink = router.link('/services/{serviceName}/dependencies', {
    path: {
      serviceName
    },
    query
  });

  // The default EuiFlexGroup breaks at 768, but we want to break at 1200, so we
  // observe the window width and set the flex directions of rows accordingly
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const isSingleColumn = isLarge;
  const latencyChartHeight = 200;
  const nonLatencyChartHeight = isSingleColumn ? latencyChartHeight : chartHeight;
  const rowDirection = isSingleColumn ? 'column' : 'row';
  return /*#__PURE__*/_react.default.createElement(_annotations_context.AnnotationsContextProvider, {
    serviceName: serviceName,
    environment: environment,
    start: start,
    end: end,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, !isAndroidAgent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_stats.MobileStats, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 8,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_geo_map.GeoMap, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters,
    filters: embeddableFilters,
    dataView: dataView,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_location_stats.MobileLocationStats, {
    start: start,
    end: end,
    kuery: kueryWithMobileFilters,
    environment: environment,
    offset: offset,
    serviceName: serviceName,
    comparisonEnabled: comparisonEnabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 23
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.mostUsedTitle', {
    defaultMessage: 'Most used'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_most_used_charts.MostUsedCharts, {
    kuery: kueryWithMobileFilters,
    start: start,
    end: end,
    environment: environment,
    transactionType: transactionType,
    serviceName: serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_chart.LatencyChart, {
    height: latencyChartHeight,
    kuery: kueryWithMobileFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_throughput_chart.ServiceOverviewThroughputChart, {
    height: nonLatencyChartHeight,
    kuery: kueryWithMobileFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_transactions_table.TransactionsTable, {
    kuery: kueryWithMobileFilters,
    environment: environment,
    fixedHeight: true,
    start: start,
    end: end,
    showPerPageOptions: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: rowDirection,
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, !isAndroidAgent && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    height: nonLatencyChartHeight,
    showAnnotations: false,
    kuery: kueryWithMobileFilters,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_service_overview_dependencies_table.ServiceOverviewDependenciesTable, {
    fixedHeight: true,
    showPerPageOptions: false,
    link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "apmMobileServiceOverviewViewDependenciesLink",
      href: dependenciesLink,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 23
      }
    }, _i18n.i18n.translate('xpack.apm.serviceOverview.dependenciesTableTabLink', {
      defaultMessage: 'View dependencies'
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 19
    }
  }))))))));
}