"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsStatus = DataStreamsStatus;
exports.getIsDataStreamTabOk = getIsDataStreamTabOk;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_diagnostics = require("../context/use_diagnostics");
var _data_stream_tab = require("../data_stream_tab");
var _tab_status = require("./tab_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/diagnostics/summary_tab/data_streams_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DataStreamsStatus() {
  const {
    diagnosticsBundle,
    status
  } = (0, _use_diagnostics.useDiagnosticsContext)();
  const router = (0, _use_apm_router.useApmRouter)();
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/diagnostics/*');
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const isOk = getIsDataStreamTabOk(diagnosticsBundle);
  return /*#__PURE__*/_react.default.createElement(_tab_status.TabStatus, {
    isLoading: isLoading,
    isOk: isOk,
    "data-test-subj": "dataStreamsStatus",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, "Data streams", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "apmDataStreamsStatusSeeDetailsLink",
    href: router.link('/diagnostics/data-streams', {
      query
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 7
    }
  }, "See details"));
}
function getIsDataStreamTabOk(diagnosticsBundle) {
  if (!diagnosticsBundle) {
    return true;
  }
  return diagnosticsBundle.dataStreams.every(ds => {
    const match = (0, _data_stream_tab.getIndexTemplateState)(diagnosticsBundle, ds.template);
    return (match === null || match === void 0 ? void 0 : match.exists) && !match.isNonStandard;
  });
}