"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiPanelStyles = exports.euiPanelBorderStyles = void 0;
var _react = require("@emotion/react");
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var euiPanelBorderStyles = exports.euiPanelBorderStyles = function euiPanelBorderStyles(euiThemeContext, options) {
  var euiTheme = euiThemeContext.euiTheme,
    colorMode = euiThemeContext.colorMode;
  var _ref3 = options !== null && options !== void 0 ? options : {},
    borderColor = _ref3.borderColor,
    _ref3$hasFloatingBord = _ref3.hasFloatingBorder,
    hasFloatingBorder = _ref3$hasFloatingBord === void 0 ? true : _ref3$hasFloatingBord;

  /* TODO: remove `hasFloatingBorder` and `hasVisibleBorder` and once Amsterdam is removed
   euiTheme.colors.borderBaseFloating is enough then */
  var hasVisibleBorder = hasFloatingBorder && colorMode === 'DARK';
  return (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    none: "\n      /* Using a pseudo element for the border instead of floating border only \n      because the transparent border might otherwise be visible with arbitrary \n      full-width/height content in light mode. */\n      &::after {\n        content: '';\n        position: absolute;\n        /* ensure to keep on top of flush content */\n        z-index: 0;\n        inset: 0;\n        border: ".concat(euiTheme.border.width.thin, " solid\n          ").concat((borderColor !== null && borderColor !== void 0 ? borderColor : hasVisibleBorder) ? euiTheme.border.color : euiTheme.colors.borderBaseFloating, ";\n        border-radius: inherit;\n        pointer-events: none;\n      }\n    "),
    preferred: "\n      border: ".concat(euiTheme.border.thin, ";\n    ")
  });
};
var _ref = process.env.NODE_ENV === "production" ? {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;"
} : {
  name: "122lw0e-grow",
  styles: "flex-grow:1;label:grow;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "1xyrf3k-euiPanel",
  styles: "position:relative;flex-grow:0;label:euiPanel;"
} : {
  name: "1xyrf3k-euiPanel",
  styles: "position:relative;flex-grow:0;label:euiPanel;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var euiPanelStyles = exports.euiPanelStyles = function euiPanelStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base
    euiPanel: _ref2,
    grow: _ref,
    hasShadow: /*#__PURE__*/(0, _react.css)((0, _euiThemeCommon.euiShadow)(euiThemeContext, 'm'), " ", euiPanelBorderStyles(euiThemeContext, {
      hasFloatingBorder: false
    }), ";;label:hasShadow;"),
    hasBorder: /*#__PURE__*/(0, _react.css)(euiPanelBorderStyles(euiThemeContext, {
      borderColor: euiTheme.border.color,
      hasFloatingBorder: false
    }), ";;label:hasBorder;"),
    radius: {
      none: /*#__PURE__*/(0, _react.css)(";label:none;"),
      m: /*#__PURE__*/(0, _react.css)("border-radius:", euiTheme.border.radius.medium, ";;label:m;")
    },
    // Setup interactive behavior
    isClickable: /*#__PURE__*/(0, _react.css)(_global_styling.euiCanAnimate, "{transition:box-shadow ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ",transform ", euiTheme.animation.fast, " ", euiTheme.animation.resistance, ";}&:enabled{display:block;", (0, _global_styling.logicalCSS)('width', '100%'), " ", (0, _global_styling.logicalTextAlignCSS)('left'), ";}&:hover,&:focus{", (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: (0, _euiThemeCommon.euiShadow)(euiThemeContext, 'l'),
      // Windows high contrast themes ignore box-shadows - use a filter workaround instead
      preferred: "\n            &:not(.euiPanel--transparent) {\n              filter: drop-shadow(0 ".concat(euiTheme.border.width.thick, " 0 ").concat(euiTheme.border.color, ");\n            }\n          ")
    }), " transform:translateY(-2px);cursor:pointer;};label:isClickable;")
  };
};