"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFlyoutChild = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
var _services = require("../../services");
var _flyout_child = require("./flyout_child.styles");
var _flyout_close_button = require("./_flyout_close_button");
var _flyout_context = require("./flyout_context");
var _flyout_body = require("./flyout_body");
var _focus_trap = require("../focus_trap");
var _react2 = require("@emotion/react");
var _excluded = ["children", "backgroundStyle", "className", "banner", "hideCloseButton", "onClose", "scrollableTabIndex", "size"];
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * Props used to render and configure the child flyout panel
 */
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
/**
 * The child flyout is a panel that appears to the left of the parent flyout.
 * It is only visible when the parent flyout is open.
 */
var EuiFlyoutChild = exports.EuiFlyoutChild = function EuiFlyoutChild(_ref) {
  var children = _ref.children,
    _ref$backgroundStyle = _ref.backgroundStyle,
    backgroundStyle = _ref$backgroundStyle === void 0 ? 'default' : _ref$backgroundStyle,
    className = _ref.className,
    banner = _ref.banner,
    _ref$hideCloseButton = _ref.hideCloseButton,
    hideCloseButton = _ref$hideCloseButton === void 0 ? false : _ref$hideCloseButton,
    onClose = _ref.onClose,
    _ref$scrollableTabInd = _ref.scrollableTabIndex,
    scrollableTabIndex = _ref$scrollableTabInd === void 0 ? 0 : _ref$scrollableTabInd,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 's' : _ref$size,
    rest = _objectWithoutProperties(_ref, _excluded);
  var flyoutContext = (0, _react.useContext)(_flyout_context.EuiFlyoutContext);
  if (!flyoutContext) {
    throw new Error('EuiFlyoutChild must be used as a child of EuiFlyout.');
  }
  var isChildFlyoutOpen = flyoutContext.isChildFlyoutOpen,
    setIsChildFlyoutOpen = flyoutContext.setIsChildFlyoutOpen,
    parentSize = flyoutContext.parentSize;
  (0, _react.useEffect)(function () {
    setIsChildFlyoutOpen === null || setIsChildFlyoutOpen === void 0 || setIsChildFlyoutOpen(true);
    return function () {
      setIsChildFlyoutOpen === null || setIsChildFlyoutOpen === void 0 || setIsChildFlyoutOpen(false);
    };
  }, [setIsChildFlyoutOpen]);
  if (_react.default.Children.count(children) === 0) {
    console.warn('EuiFlyoutChild was rendered with no children!');
  }
  if (parentSize === 'm' && size === 'm') {
    throw new Error('When the parent EuiFlyout size is "m", the EuiFlyoutChild size cannot be "m". Please use size "s" for the EuiFlyoutChild.');
  }
  var handleClose = function handleClose(event) {
    setIsChildFlyoutOpen === null || setIsChildFlyoutOpen === void 0 || setIsChildFlyoutOpen(false);
    onClose(event);
  };
  var flyoutTitleText;
  var hasDescribedByBody = false;
  _react.Children.forEach(children, function (child) {
    if ( /*#__PURE__*/_react.default.isValidElement(child)) {
      var _child$type;
      if (((_child$type = child.type) === null || _child$type === void 0 ? void 0 : _child$type.displayName) === 'EuiFlyoutHeader') {
        // Attempt to extract string content from header for ARIA
        var headerChildren = child.props.children;
        if (typeof headerChildren === 'string') {
          flyoutTitleText = headerChildren;
        } else if ( /*#__PURE__*/_react.default.isValidElement(headerChildren) &&
        // Check if props exist and children is a string
        typeof headerChildren.props.children === 'string') {
          flyoutTitleText = headerChildren.props.children;
        } else if (Array.isArray(headerChildren)) {
          // Find the first string child if headerChildren is an array
          flyoutTitleText = headerChildren.find(function (cNode) {
            return typeof cNode === 'string';
          });
        }
      }
      if (child.type === _flyout_body.EuiFlyoutBody) {
        hasDescribedByBody = true;
      }
    }
  });
  var titleIdGenerated = (0, _services.useGeneratedHtmlId)({
    prefix: 'euiFlyoutChildTitle'
  });
  var bodyIdGenerated = (0, _services.useGeneratedHtmlId)({
    prefix: 'euiFlyoutChildBody'
  });
  var ariaLabelledBy = flyoutTitleText ? titleIdGenerated : undefined;
  var ariaDescribedBy = hasDescribedByBody ? bodyIdGenerated : undefined;
  // Use existing aria-label if provided, otherwise fallback if no labelledby can be derived
  var ariaLabel = rest['aria-label'] || (!ariaLabelledBy && !flyoutTitleText ? 'Flyout panel' : undefined);
  var processedChildren = (0, _react.useMemo)(function () {
    return _react.Children.map(children, function (child) {
      if ( /*#__PURE__*/_react.default.isValidElement(child)) {
        var _child$type2, _child$type3;
        if ((child.type === _flyout_body.EuiFlyoutBody || ((_child$type2 = child.type) === null || _child$type2 === void 0 ? void 0 : _child$type2.displayName) === 'EuiFlyoutBody') && hasDescribedByBody) {
          return /*#__PURE__*/_react.default.cloneElement(child, {
            id: bodyIdGenerated
          });
        }
        // If EuiFlyoutHeader is found and we derived flyoutTitleText, set its ID
        if (((_child$type3 = child.type) === null || _child$type3 === void 0 ? void 0 : _child$type3.displayName) === 'EuiFlyoutHeader' && flyoutTitleText && ariaLabelledBy) {
          return /*#__PURE__*/_react.default.cloneElement(child, {
            id: titleIdGenerated
          });
        }
      }
      return child;
    });
  }, [children, bodyIdGenerated, titleIdGenerated, hasDescribedByBody, flyoutTitleText, ariaLabelledBy]);
  var flyoutWrapperRef = (0, _react.useRef)(null);
  var classes = (0, _classnames.default)('euiFlyoutChild', className);
  var styles = (0, _services.useEuiMemoizedStyles)(_flyout_child.euiFlyoutChildStyles);
  var childLayoutMode = flyoutContext.childLayoutMode,
    parentFlyoutRef = flyoutContext.parentFlyoutRef;
  var flyoutChildCss = [styles.euiFlyoutChild, backgroundStyle === 'shaded' ? styles.backgroundShaded : styles.backgroundDefault, size === 's' ? styles.s : styles.m, childLayoutMode === 'side-by-side' ? styles.sidePosition : styles.stackedPosition];
  var onKeyDown = (0, _react.useCallback)(function (event) {
    if (isChildFlyoutOpen && event.key === _services.keys.ESCAPE) {
      event.preventDefault();
      setIsChildFlyoutOpen === null || setIsChildFlyoutOpen === void 0 || setIsChildFlyoutOpen(false);
      onClose(event.nativeEvent);
    }
  }, [isChildFlyoutOpen, onClose, setIsChildFlyoutOpen]);
  return (0, _react2.jsx)(_focus_trap.EuiFocusTrap, {
    returnFocus: function returnFocus() {
      if (parentFlyoutRef !== null && parentFlyoutRef !== void 0 && parentFlyoutRef.current) {
        parentFlyoutRef.current.focus();
        return false; // We've handled focus
      }
      return true;
    },
    shards: [],
    disabled: false
  }, (0, _react2.jsx)("div", _extends({
    ref: flyoutWrapperRef,
    className: classes,
    css: flyoutChildCss,
    "data-test-subj": "euiFlyoutChild",
    role: "dialog",
    "aria-modal": "true",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    "aria-describedby": ariaDescribedBy,
    tabIndex: -1,
    onKeyDown: onKeyDown // used as generic container event handler
  }, rest), flyoutTitleText && !ariaLabelledBy && (0, _react2.jsx)("h2", {
    id: titleIdGenerated,
    className: "euiScreenReaderOnly"
  }, flyoutTitleText), !hideCloseButton && (0, _react2.jsx)(_flyout_close_button.EuiFlyoutCloseButton, {
    className: "euiFlyoutChild__closeButton",
    onClose: handleClose,
    side: "right",
    closeButtonPosition: "inside",
    "data-test-subj": "euiFlyoutChildCloseButton"
  }), (0, _react2.jsx)("div", {
    tabIndex: scrollableTabIndex,
    className: "euiFlyoutChild__overflow",
    css: styles.overflow.overflow
  }, banner && (0, _react2.jsx)("div", {
    className: "euiFlyoutChild__banner",
    css: styles.banner,
    "data-test-subj": "euiFlyoutChildBanner"
  }, banner), (0, _react2.jsx)("div", {
    className: "euiFlyoutChild__overflowContent",
    css: styles.overflow.wrapper
  }, processedChildren))));
};
EuiFlyoutChild.propTypes = {
  /**
     * Called when the child panel's close button is clicked
     */
  onClose: _propTypes.default.func.isRequired,
  /**
     * Use to display a banner at the top of the child. It is suggested to use `EuiCallOut` for it.
     */
  banner: _propTypes.default.node,
  /**
     * Hides the default close button. You must provide another close button somewhere within the child flyout.
     * @default false
     */
  hideCloseButton: _propTypes.default.bool,
  /**
     * [Scrollable regions (or their children) should be focusable](https://dequeuniversity.com/rules/axe/4.0/scrollable-region-focusable)
     * to allow keyboard users to scroll the region via arrow keys.
     *
     * By default, EuiFlyoutChild's scroll overflow wrapper sets a `tabIndex` of `0`.
     * If you know your flyout child content already contains focusable children
     * that satisfy keyboard accessibility requirements, you can use this prop
     * to override this default.
     */
  scrollableTabIndex: _propTypes.default.number,
  /**
     * Size of the child flyout panel.
     * When the parent flyout is 'm', child is limited to 's'.
     * @default 's'
     */
  size: _propTypes.default.oneOf(["s", "m"]),
  /*
     * The background of the child flyout can be optionally shaded. Use `shaded` to add the shading.
     */
  backgroundStyle: _propTypes.default.oneOf(["shaded", "default"]),
  /**
     * Children are implicitly part of FunctionComponent, but good to have if props type is standalone.
     */
  children: _propTypes.default.node,
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  css: _propTypes.default.any
};
EuiFlyoutChild.displayName = 'EuiFlyoutChild';