"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypesHelpPopover = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactField = require("@kbn/react-field");
var _i18nReact = require("@kbn/i18n-react");
var _get_field_type_description = require("@kbn/field-utils/src/utils/get_field_type_description");
var _kibana_context = require("../../../kibana_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/field_types_filter/field_types_help_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FieldTypesHelpPopover = ({
  fieldTypes
}) => {
  {
    const {
      services
    } = (0, _kibana_context.useDataVisualizerKibana)();
    const {
      docLinks
    } = services;
    const {
      euiTheme
    } = (0, _eui.useEuiTheme)();
    const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(false);
    const onHelpClick = () => setIsHelpOpen(prevIsHelpOpen => !prevIsHelpOpen);
    const closeHelp = () => setIsHelpOpen(false);
    const items = (0, _react.useMemo)(() => fieldTypes.map((type, index) => ({
      id: index,
      dataType: type,
      description: (0, _get_field_type_description.getFieldTypeDescription)(type)
    })), [fieldTypes]);
    const columnsSidebar = [{
      field: 'dataType',
      name: _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.dataTypeColumnTitle', {
        defaultMessage: 'Data type'
      }),
      width: '110px',
      render: name => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false,
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
        type: name,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 70,
          columnNumber: 13
        }
      }, name))
    }, {
      field: 'description',
      name: _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.descriptionColumnTitle', {
        defaultMessage: 'Description'
      }),
      // eslint-disable-next-line react/no-danger
      render: description => /*#__PURE__*/_react.default.createElement("div", {
        dangerouslySetInnerHTML: {
          __html: description
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 42
        }
      })
    }];
    const helpButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      grow: false,
      isSelected: isHelpOpen,
      onClick: onHelpClick,
      "data-test-subj": "fieldTypesHelpButton",
      className: "dataVisualizerFieldTypesHelp__button",
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.buttonAriaLabel', {
        defaultMessage: 'Filter type help'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: "primary",
      title: _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.iconTitle', {
        defaultMessage: 'Filter type help'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 9
      }
    }));
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downLeft",
      display: "block",
      button: helpButton,
      isOpen: isHelpOpen,
      panelPaddingSize: "none",
      closePopover: closeHelp,
      initialFocus: "dataVisualizerFieldTypesHelpBasicTableId",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.fieldChooser.popoverTitle', {
      defaultMessage: 'Field types'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      className: "eui-yScroll",
      style: {
        maxHeight: '50vh',
        maxWidth: `calc(${euiTheme.size.base}*22)`
      },
      color: "transparent",
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      id: "dataVisualizerFieldTypesHelpBasicTableId",
      tableCaption: _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.tableTitle', {
        defaultMessage: 'Description of field types'
      }),
      items: items,
      compressed: true,
      rowHeader: "firstName",
      columns: columnsSidebar,
      responsiveBreakpoint: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "transparent",
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.fieldTypesPopover.learnMoreText', {
      defaultMessage: 'Learn more about'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: docLinks.links.discover.fieldTypeHelp,
      target: "_blank",
      external: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.fieldTypesPopover.fieldTypesDocLinkLabel",
      defaultMessage: "field types",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }))))));
  }
};
exports.FieldTypesHelpPopover = FieldTypesHelpPopover;