"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FileBasedDataVisualizerExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_expanded_row_css = require("./use_expanded_row_css");
var _field_data_expanded_row = require("../stats_table/components/field_data_expanded_row");
var _geo_point_content = require("./geo_point_content/geo_point_content");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/expanded_row/file_based_expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FileBasedDataVisualizerExpandedRow = ({
  item
}) => {
  const config = item;
  const {
    type,
    fieldName
  } = config;
  const dvExpandedRow = (0, _use_expanded_row_css.useExpandedRowCss)();
  function getCardContent() {
    switch (type) {
      case _constants.SUPPORTED_FIELD_TYPES.NUMBER:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.NumberContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 31,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.BOOLEAN:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.BooleanContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 34,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.DATE:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.DateContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 37,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.GEO_POINT:
        return /*#__PURE__*/_react.default.createElement(_geo_point_content.GeoPointContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.IP:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.IpContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 43,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.KEYWORD:
      case _constants.SUPPORTED_FIELD_TYPES.VERSION:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.KeywordContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 16
          }
        });
      case _constants.SUPPORTED_FIELD_TYPES.TEXT:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.TextContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 16
          }
        });
      default:
        return /*#__PURE__*/_react.default.createElement(_field_data_expanded_row.OtherContent, {
          config: config,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 53,
            columnNumber: 16
          }
        });
    }
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    css: dvExpandedRow,
    "data-test-subj": `dataVisualizerFieldExpandedRow-${fieldName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, getCardContent());
};
exports.FileBasedDataVisualizerExpandedRow = FileBasedDataVisualizerExpandedRow;