"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateEditField = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _index_header = require("../index_header");
var _constants = require("../constants");
var _field_editor = require("../../field_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/create_edit_field/create_edit_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const newFieldPlaceholder = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.scripted.newFieldPlaceholder', {
  defaultMessage: 'New Scripted Field'
});
const CreateEditField = exports.CreateEditField = (0, _reactRouterDom.withRouter)(({
  indexPattern,
  mode,
  fieldName,
  history
}) => {
  var _indexPattern$fields$;
  const {
    uiSettings,
    chrome,
    notifications,
    dataViews
  } = (0, _public.useKibana)().services;
  const spec = mode === 'edit' && fieldName ? (_indexPattern$fields$ = indexPattern.fields.getByName(fieldName)) === null || _indexPattern$fields$ === void 0 ? void 0 : _indexPattern$fields$.spec : {
    scripted: true,
    type: 'number',
    name: undefined
  };
  const url = `/dataView/${indexPattern.id}`;
  if (mode === 'edit' && !spec) {
    const message = _i18n.i18n.translate('indexPatternManagement.editDataView.scripted.noFieldLabel', {
      defaultMessage: "''{dataViewTitle}'' data view doesn't have a scripted field called ''{fieldName}''",
      values: {
        dataViewTitle: indexPattern.title,
        fieldName
      }
    });
    notifications.toasts.addWarning(message);
    history.push(url);
  }
  const docFieldName = (spec === null || spec === void 0 ? void 0 : spec.name) || newFieldPlaceholder;
  chrome.docTitle.change([docFieldName, indexPattern.getName()]);
  const redirectAway = () => {
    history.push(`${url}#/?_a=(tab:${spec !== null && spec !== void 0 && spec.scripted ? _constants.TAB_SCRIPTED_FIELDS : _constants.TAB_INDEXED_FIELDS})`);
  };
  if (spec) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_header.IndexHeader, {
      indexPattern: indexPattern,
      defaultIndex: uiSettings.get('defaultIndex'),
      canSave: dataViews.getCanSaveSync(),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: 'l',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_field_editor.FieldEditor, {
      indexPattern: indexPattern,
      spec: spec,
      services: {
        indexPatternService: dataViews,
        redirectAway
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
});