"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _date_picker = require("./date_picker");
var _charts_filter = require("./charts_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_usage/public/app/components/filters/charts_filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ChartsFilters = exports.ChartsFilters = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  isUpdateDisabled,
  isValidDateRange,
  filterOptions,
  onClick,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  showMetricsTypesFilter = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const filters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showMetricsTypesFilter && /*#__PURE__*/_react.default.createElement(_charts_filter.ChartsFilter, {
      filterOptions: filterOptions.metricTypes,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }), !filterOptions.dataStreams.isFilterLoading && /*#__PURE__*/_react.default.createElement(_charts_filter.ChartsFilter, {
      filterOptions: filterOptions.dataStreams,
      "data-test-subj": dataTestSubj,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 13
      }
    }));
  }, [dataTestSubj, filterOptions, showMetricsTypesFilter]);
  const onClickRefreshButton = (0, _react.useCallback)(() => onClick(), [onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "m",
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, filters)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_date_picker.UsageMetricsDateRangePicker, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isDataLoading,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }), !isValidDateRange && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    "data-test-subj": getTestId('invalid-date-range'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 17
    }
  }, _translations.UX_LABELS.filters.invalidDateRange)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
    "data-test-subj": getTestId('super-refresh-button'),
    fill: false,
    isLoading: isDataLoading,
    isDisabled: isUpdateDisabled,
    onClick: onClickRefreshButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }));
});
ChartsFilters.displayName = 'ChartsFilters';