"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Dashboard404Page = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPromptNotFound = require("@kbn/shared-ux-prompt-not-found");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_renderer/dashboard_404.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Dashboard404Page = ({
  dashboardRedirect
}) => {
  return /*#__PURE__*/_react.default.createElement(_sharedUxPromptNotFound.NotFoundPrompt, {
    title: _i18n.i18n.translate('dashboard.renderer.404Title', {
      defaultMessage: 'Dashboard not found'
    }),
    body: _i18n.i18n.translate('dashboard.renderer.404Body', {
      defaultMessage: "Sorry, the dashboard you're looking for can't be found. It might have been removed or renamed, or maybe it never existed at all."
    }),
    actions: dashboardRedirect ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft",
      flush: "both",
      onClick: () => dashboardRedirect({
        destination: 'listing'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('dashboard.renderer.404Action', {
      defaultMessage: 'View available dashboards'
    }))] : undefined // if dashboard redirect not given, fall back to `go back`.
    ,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  });
};
exports.Dashboard404Page = Dashboard404Page;