"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _secondary_menu = require("../secondary_menu");
var _use_nested_menu = require("./use_nested_menu");
var _get_focusable_elements = require("../../utils/get_focusable_elements");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/nested_secondary_menu/menu_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Panel = ({
  children,
  id,
  title
}) => {
  const {
    currentPanel,
    panelStackDepth,
    returnFocusId
  } = (0, _use_nested_menu.useNestedMenu)();
  const panelRef = (0, _react.useCallback)(node => {
    if (currentPanel !== id) return;

    // If we have a return focus id, we focus the trigger element
    if (returnFocusId && node) {
      const triggerElement = node.querySelector(`#${CSS.escape(returnFocusId)}`);
      if (triggerElement) return triggerElement.focus();
    }

    // If we are at the root panel, we don't need to focus anything
    if (panelStackDepth === 0) return;

    // Otherwise, we focus the first focusable element in the panel
    if (node) {
      var _elements$;
      const elements = (0, _get_focusable_elements.getFocusableElements)(node);
      (_elements$ = elements[0]) === null || _elements$ === void 0 ? void 0 : _elements$.focus();
    }
  }, [currentPanel, id, panelStackDepth, returnFocusId]);
  if (currentPanel !== id) return null;
  if (title) {
    return /*#__PURE__*/_react.default.createElement(_secondary_menu.SecondaryMenu, {
      "data-test-subj": `nestedSecondaryMenuPanel-${id}`,
      ref: panelRef,
      title: title,
      isPanel: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }, children);
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `nestedSecondaryMenuPanel-${id}`,
    ref: panelRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, children);
};
exports.Panel = Panel;