"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupUrlOverflowDetection = exports.URL_WARNING_LENGTH = exports.URL_MAX_LENGTH = exports.IS_IE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _coreMountUtilsBrowserInternal = require("@kbn/core-mount-utils-browser-internal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/apps/browser-internal/src/errors/url_overflow.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const IE_REGEX = /(; ?MSIE |Edge\/\d|Trident\/[\d+\.]+;.*rv:*11\.\d+)/;
const IS_IE = exports.IS_IE = IE_REGEX.test(window.navigator.userAgent);
/**
 * The max URL length allowed by the current browser. Should be used to display warnings to users when query parameters
 * cause URL to exceed this limit.
 * @public
 */
const URL_MAX_LENGTH = exports.URL_MAX_LENGTH = IS_IE ? 2000 : 25000;
const URL_WARNING_LENGTH = exports.URL_WARNING_LENGTH = IS_IE ? 1000 : 24000;
const ERROR_ROUTE = '/app/error';
const setupUrlOverflowDetection = ({
  basePath,
  history,
  toasts,
  uiSettings
}) => history.listen(location => {
  // Bail if storeInSessionStorage is set or we're already on the error page
  if (uiSettings.get('state:storeInSessionStorage') || history.location.pathname.startsWith(ERROR_ROUTE)) {
    return;
  }
  const absUrl = history.createHref(location);
  const absUrlLength = absUrl.length;
  if (absUrlLength > URL_MAX_LENGTH) {
    const href = history.createHref({
      pathname: ERROR_ROUTE,
      search: `errorType=urlOverflow`
    });
    // Force the browser to reload so that any potentially unstable state is unloaded
    window.location.assign(href);
    // window.location.href = href;
    // window.location.reload();
  } else if (absUrlLength >= URL_WARNING_LENGTH) {
    toasts.addWarning({
      title: _i18n.i18n.translate('core.ui.errorUrlOverflow.bigUrlWarningNotificationTitle', {
        defaultMessage: 'The URL is big and Kibana might stop working'
      }),
      text: (0, _coreMountUtilsBrowserInternal.mountReactNode)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "core.ui.errorUrlOverflow.bigUrlWarningNotificationMessage",
        defaultMessage: "Either enable the {storeInSessionStorageParam} option in {advancedSettingsLink} or simplify the onscreen visuals.",
        values: {
          storeInSessionStorageParam: /*#__PURE__*/_react.default.createElement("code", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 72,
              columnNumber: 43
            }
          }, "state:storeInSessionStorage"),
          advancedSettingsLink: /*#__PURE__*/_react.default.createElement("a", {
            href: basePath.prepend('/app/management/kibana/settings'),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 74,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "core.ui.errorUrlOverflow.bigUrlWarningNotificationMessage.advancedSettingsLinkText",
            defaultMessage: "advanced settings",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 75,
              columnNumber: 19
            }
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }))
    });
  }
});
exports.setupUrlOverflowDetection = setupUrlOverflowDetection;