"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCAICommentsBackfillTaskId = exports.CAI_COMMENTS_SYNC_TYPE = exports.CAI_COMMENTS_SOURCE_INDEX = exports.CAI_COMMENTS_INDEX_VERSION = exports.CAI_COMMENTS_INDEX_NAME_BASE = exports.CAI_COMMENTS_INDEX_ALIAS_BASE = void 0;
exports.getCommentsDestinationIndexAlias = getCommentsDestinationIndexAlias;
exports.getCommentsDestinationIndexName = getCommentsDestinationIndexName;
exports.getCommentsSynchronizationSourceQuery = exports.getCommentsSourceQuery = void 0;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CAI_COMMENTS_INDEX_NAME_BASE = exports.CAI_COMMENTS_INDEX_NAME_BASE = '.internal.cases-comments';
function getCommentsDestinationIndexName(spaceId, owner) {
  return `${CAI_COMMENTS_INDEX_NAME_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_COMMENTS_INDEX_ALIAS_BASE = exports.CAI_COMMENTS_INDEX_ALIAS_BASE = '.cases-comments';
function getCommentsDestinationIndexAlias(spaceId, owner) {
  return `${CAI_COMMENTS_INDEX_ALIAS_BASE}.${owner}-${spaceId}`.toLowerCase();
}
const CAI_COMMENTS_INDEX_VERSION = exports.CAI_COMMENTS_INDEX_VERSION = 1;
const CAI_COMMENTS_SYNC_TYPE = exports.CAI_COMMENTS_SYNC_TYPE = 'cai_comments_sync';
const getCommentsSourceQuery = (spaceId, owner) => ({
  bool: {
    filter: [{
      term: {
        type: 'cases-comments'
      }
    }, {
      term: {
        'cases-comments.type': 'user'
      }
    }, {
      term: {
        namespaces: spaceId
      }
    }, {
      term: {
        'cases-comments.owner': owner
      }
    }]
  }
});
exports.getCommentsSourceQuery = getCommentsSourceQuery;
const CAI_COMMENTS_SOURCE_INDEX = exports.CAI_COMMENTS_SOURCE_INDEX = _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX;
const CAI_COMMENTS_BACKFILL_TASK_ID = 'cai_comments_backfill_task';
const getCAICommentsBackfillTaskId = (spaceId, owner) => {
  return `${CAI_COMMENTS_BACKFILL_TASK_ID}-${owner}-${spaceId}`;
};
exports.getCAICommentsBackfillTaskId = getCAICommentsBackfillTaskId;
const getCommentsSynchronizationSourceQuery = (lastSyncAt, spaceId, owner) => {
  var _getCommentsSourceQue;
  return {
    bool: {
      filter: (_getCommentsSourceQue = getCommentsSourceQuery(spaceId, owner).bool) === null || _getCommentsSourceQue === void 0 ? void 0 : _getCommentsSourceQue.filter,
      must: [{
        bool: {
          should: [{
            range: {
              'cases-comments.created_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }, {
            range: {
              'cases-comments.updated_at': {
                gte: lastSyncAt.toISOString()
              }
            }
          }]
        }
      }]
    }
  };
};
exports.getCommentsSynchronizationSourceQuery = getCommentsSynchronizationSourceQuery;