"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteAttachmentConfirmationModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("./property_actions/translations");
var _use_focus_button = require("../use_focus_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_actions/delete_attachment_confirmation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DeleteAttachmentConfirmationModalComponent = ({
  title,
  confirmButtonText,
  onConfirm,
  onCancel,
  focusButtonRef
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const focusTrapProps = (0, _use_focus_button.useFocusButtonTrap)(focusButtonRef);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: title,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _translations.CANCEL_BUTTON,
    confirmButtonText: confirmButtonText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "property-actions-confirm-modal",
    "aria-labelledby": modalTitleId,
    focusTrapProps: focusTrapProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
};
DeleteAttachmentConfirmationModalComponent.displayName = 'DeleteAttachmentConfirmationModal';
const DeleteAttachmentConfirmationModal = exports.DeleteAttachmentConfirmationModal = /*#__PURE__*/_react.default.memo(DeleteAttachmentConfirmationModalComponent);