"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.LensEditor = void 0;
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("./constants");
var _context = require("../../context");
var _use_lens_draft_comment = require("./use_lens_draft_comment");
var _translations = require("./translations");
var _hooks = require("../../../../common/hooks");
var _convert_to_absolute_time_range = require("../../../visualizations/actions/convert_to_absolute_time_range");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/markdown_editor/plugins/lens/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_TIMERANGE = {
  from: 'now-7d',
  to: 'now',
  mode: 'relative'
};
const LensEditorComponent = ({
  node,
  onCancel,
  onSave
}) => {
  const location = (0, _reactRouterDom.useLocation)();
  const {
    application: {
      currentAppId$
    },
    embeddable,
    lens,
    storage,
    contentManagement,
    uiSettings,
    data: {
      query: {
        timefilter: {
          timefilter
        }
      }
    }
  } = (0, _kibana.useKibana)().services;
  const [currentAppId, setCurrentAppId] = (0, _react.useState)(undefined);
  const {
    draftComment,
    clearDraftComment
  } = (0, _use_lens_draft_comment.useLensDraftComment)();
  const commentEditorContext = (0, _react.useContext)(_context.CommentEditorContext);
  const markdownContext = (0, _react.useContext)(_eui.EuiMarkdownContext);
  const isMainApplication = (0, _hooks.useIsMainApplication)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleClose = (0, _react.useCallback)(() => {
    if (currentAppId) {
      embeddable === null || embeddable === void 0 ? void 0 : embeddable.getStateTransfer().getIncomingEmbeddablePackage(currentAppId, true);
      clearDraftComment();
    }
    onCancel();
  }, [clearDraftComment, currentAppId, embeddable, onCancel]);
  const handleAdd = (0, _react.useCallback)((attributes, timeRange) => {
    onSave(`!{${_constants.ID}${JSON.stringify({
      timeRange: (0, _convert_to_absolute_time_range.convertToAbsoluteTimeRange)(timeRange),
      attributes
    })}}`, {
      block: true
    });
    handleClose();
  }, [handleClose, onSave]);
  const handleUpdate = (0, _react.useCallback)((attributes, timeRange, position) => {
    markdownContext.replaceNode(position, `!{${_constants.ID}${JSON.stringify({
      timeRange: (0, _convert_to_absolute_time_range.convertToAbsoluteTimeRange)(timeRange),
      attributes
    })}}`);
    handleClose();
  }, [handleClose, markdownContext]);
  const originatingPath = (0, _react.useMemo)(() => isMainApplication ? `/insightsAndAlerting/cases${location.pathname}${location.search}` : `${location.pathname}${location.search}`, [isMainApplication, location.pathname, location.search]);
  const handleCreateInLensClick = (0, _react.useCallback)(() => {
    storage.set(_constants.DRAFT_COMMENT_STORAGE_ID, {
      commentId: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId,
      comment: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value,
      position: node === null || node === void 0 ? void 0 : node.position,
      caseTitle: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle,
      caseTags: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags
    });
    lens === null || lens === void 0 ? void 0 : lens.navigateToPrefilledEditor(undefined, {
      originatingApp: currentAppId,
      originatingPath
    });
  }, [storage, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags, node === null || node === void 0 ? void 0 : node.position, lens, currentAppId, originatingPath]);
  const handleEditInLensClick = (0, _react.useCallback)((lensAttributes, timeRange = DEFAULT_TIMERANGE) => {
    storage.set(_constants.DRAFT_COMMENT_STORAGE_ID, {
      commentId: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId,
      comment: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value,
      position: node === null || node === void 0 ? void 0 : node.position,
      caseTitle: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle,
      caseTags: commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags
    });
    lens === null || lens === void 0 ? void 0 : lens.navigateToPrefilledEditor(lensAttributes || node !== null && node !== void 0 && node.attributes ? {
      id: '',
      timeRange,
      attributes: lensAttributes || (node === null || node === void 0 ? void 0 : node.attributes)
    } : undefined, {
      originatingApp: currentAppId,
      originatingPath
    });
  }, [storage, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.editorId, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.value, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTitle, commentEditorContext === null || commentEditorContext === void 0 ? void 0 : commentEditorContext.caseTags, node === null || node === void 0 ? void 0 : node.position, node === null || node === void 0 ? void 0 : node.attributes, lens, currentAppId, originatingPath]);
  const handleChooseLensSO = (0, _react.useCallback)((savedObjectId, savedObjectType, fullName, savedObject) => {
    handleEditInLensClick({
      ...savedObject.attributes,
      title: '',
      references: savedObject.references
    });
  }, [handleEditInLensClick]);
  const savedObjectMetaData = (0, _react.useMemo)(() => [{
    type: 'lens',
    getIconForSavedObject: () => 'lensApp',
    name: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.savedObjectType.lens', {
      defaultMessage: 'Lens'
    }),
    includeFields: ['*']
  }], []);
  (0, _react.useEffect)(() => {
    if (node !== null && node !== void 0 && node.attributes && currentAppId) {
      handleEditInLensClick(node.attributes, node.timeRange);
    }
  }, [handleEditInLensClick, node, currentAppId]);
  (0, _react.useEffect)(() => {
    const getCurrentAppId = async () => {
      const appId = await currentAppId$.pipe((0, _rxjs.first)()).toPromise();
      setCurrentAppId(appId);
    };
    getCurrentAppId();
  }, [currentAppId$]);
  (0, _react.useEffect)(() => {
    var _incomingEmbeddablePa, _incomingEmbeddablePa2, _incomingEmbeddablePa3, _incomingEmbeddablePa4;
    let incomingEmbeddablePackage;
    if (currentAppId) {
      incomingEmbeddablePackage = embeddable === null || embeddable === void 0 ? void 0 : embeddable.getStateTransfer().getIncomingEmbeddablePackage(currentAppId, true);
    }
    if (((_incomingEmbeddablePa = incomingEmbeddablePackage) === null || _incomingEmbeddablePa === void 0 ? void 0 : _incomingEmbeddablePa.type) === 'lens' && (_incomingEmbeddablePa2 = incomingEmbeddablePackage) !== null && _incomingEmbeddablePa2 !== void 0 && (_incomingEmbeddablePa3 = _incomingEmbeddablePa2.serializedState) !== null && _incomingEmbeddablePa3 !== void 0 && (_incomingEmbeddablePa4 = _incomingEmbeddablePa3.rawState) !== null && _incomingEmbeddablePa4 !== void 0 && _incomingEmbeddablePa4.attributes) {
      const lensTime = timefilter.getTime();
      const newTimeRange = lensTime !== null && lensTime !== void 0 && lensTime.from && lensTime !== null && lensTime !== void 0 && lensTime.to ? {
        from: lensTime.from,
        to: lensTime.to,
        mode: [lensTime.from, lensTime.to].join('').includes('now') ? 'relative' : 'absolute'
      } : undefined;
      if (draftComment !== null && draftComment !== void 0 && draftComment.position) {
        handleUpdate(incomingEmbeddablePackage.serializedState.rawState.attributes, newTimeRange, draftComment.position);
        return;
      }
      if (draftComment) {
        handleAdd(incomingEmbeddablePackage.serializedState.rawState.attributes, newTimeRange);
      }
    }
  }, [embeddable, storage, timefilter, currentAppId, handleAdd, handleUpdate, draftComment]);
  const createLensButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleCreateInLensClick,
    iconType: "plusInCircle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.createVisualizationButtonLabel",
    defaultMessage: "Create new",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        width: ${euiTheme.breakpoint.m};
        height: 100%;

        .euiModalBody {
          min-height: 300px;
        }
      `,
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.addVisualizationModalTitle",
    defaultMessage: "Add visualization",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: (0, _react2.css)`
                display: inline-flex;

                .euiToolTipAnchor {
                  display: inline-flex;
                }
              `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.betaLabel', {
      defaultMessage: 'Beta'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.betaDescription', {
      defaultMessage: 'This module is not GA. You can only insert one lens per comment for now. Please help us by reporting bugs.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    id: "casesMarkdownLens",
    onChoose: handleChooseLensSO,
    showFilter: false,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.notFoundLabel",
      defaultMessage: "No matching lens found.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 348,
        columnNumber: 13
      }
    }),
    savedObjectMetaData: savedObjectMetaData,
    fixedPageSize: 10,
    services: {
      contentClient: contentManagement.client,
      uiSettings
    },
    leftChildren: createLensButton,
    helpText: _i18n.i18n.translate('xpack.cases.markdownEditor.plugins.lens.savedObjects.finder.searchInputHelpText', {
      defaultMessage: 'Insert an existing lens visualization or create a new one. Any changes or new visualizations will only apply to this comment.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 342,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 369,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: handleClose,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cases.markdownEditor.plugins.lens.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 371,
      columnNumber: 11
    }
  }))));
};
LensEditorComponent.displayName = 'LensEditor';
const LensEditor = exports.LensEditor = /*#__PURE__*/_react.default.memo(LensEditorComponent);
const plugin = exports.plugin = {
  name: _constants.ID,
  button: {
    label: _translations.VISUALIZATION,
    iconType: 'lensApp'
  },
  helpText: /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "md",
    paddingSize: "s",
    fontSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 5
    }
  }, '!{lens<config>}'),
  editor: LensEditor
};