"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _links = require("../links");
var i18n = _interopRequireWildcard(require("./translations"));
var _navigation = require("../../common/navigation");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CasesTable = ({
  columns,
  data,
  goToCreateCase,
  isCasesLoading,
  isCommentUpdating,
  isDataEmpty,
  isSelectorView,
  onChange,
  pagination,
  selection,
  sorting,
  tableRef,
  tableRowProps,
  isLoadingColumns,
  rowHeader
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const {
    getCreateCaseUrl,
    navigateToCreateCase
  } = (0, _navigation.useCreateCaseNavigation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const navigateToCreateCaseClick = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    if (goToCreateCase != null) {
      goToCreateCase();
    } else {
      navigateToCreateCase();
    }
  }, [goToCreateCase, navigateToCreateCase]);
  const isInitialLoading = (0, _react.useMemo)(() => isCasesLoading && isDataEmpty || isLoadingColumns && columns.length === 0, [isCasesLoading, isDataEmpty, isLoadingColumns, columns]);
  const isLoading = (0, _react.useMemo)(() => isCasesLoading || isLoadingColumns || isCommentUpdating, [isCasesLoading, isLoadingColumns, isCommentUpdating]);
  return isInitialLoading ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        margin-top: ${euiTheme.size.m};
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    "data-test-subj": "initialLoadingPanelAllCases",
    lines: 10,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    className: (0, _classnames.default)({
      isSelectorView
    }),
    columns: columns,
    rowHeader: rowHeader,
    "data-test-subj": "cases-table",
    itemId: "id",
    items: data.cases,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 20
        }
      }, i18n.NO_CASES),
      titleSize: "xs",
      body: permissions.create ? i18n.NO_CASES_BODY : i18n.NO_CASES_BODY_READ_ONLY,
      actions: permissions.create && /*#__PURE__*/_react.default.createElement(_links.LinkButton, {
        isDisabled: !permissions.create,
        fill: true,
        size: "s",
        onClick: navigateToCreateCaseClick,
        href: getCreateCaseUrl(),
        iconType: "plusInCircle",
        "data-test-subj": "cases-table-add-case",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 17
        }
      }, i18n.CREATE_CASE_TITLE),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }),
    onChange: onChange,
    pagination: pagination,
    ref: tableRef,
    rowProps: tableRowProps,
    selection: !isSelectorView ? selection : undefined,
    sorting: sorting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }));
};
exports.CasesTable = CasesTable;
CasesTable.displayName = 'CasesTable';