"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePicker = DatePicker;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/data-plugin/common");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _call_api = require("../../../services/rest/call_api");
var _url_helpers = require("../links/url_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/date_picker/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DatePicker({
  rangeFrom,
  rangeTo,
  refreshPaused,
  refreshInterval,
  onTimeRangeRefresh
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const {
    core,
    plugins
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const timePickerQuickRanges = core.uiSettings.get(_common.UI_SETTINGS.TIMEPICKER_QUICK_RANGES);
  const commonlyUsedRanges = timePickerQuickRanges.map(({
    from,
    to,
    display
  }) => ({
    start: from,
    end: to,
    label: display
  }));
  function updateUrl(nextQuery) {
    history.push({
      ...location,
      search: (0, _url_helpers.fromQuery)({
        ...(0, _url_helpers.toQuery)(location.search),
        ...nextQuery
      })
    });
  }
  function onRefreshChange({
    nextRefreshPaused,
    nextRefreshInterval
  }) {
    updateUrl({
      refreshPaused: nextRefreshPaused,
      refreshInterval: nextRefreshInterval
    });
  }
  function onTimeChange({
    start,
    end
  }) {
    updateUrl({
      rangeFrom: start,
      rangeTo: end
    });
  }
  (0, _react.useEffect)(() => {
    // set time if both to and from are given in the url
    if (rangeFrom && rangeTo) {
      plugins.data.query.timefilter.timefilter.setTime({
        from: rangeFrom,
        to: rangeTo
      });
      return;
    }
  }, [rangeFrom, rangeTo, plugins]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: rangeFrom,
    end: rangeTo,
    isPaused: refreshPaused,
    refreshInterval: refreshInterval,
    onTimeChange: onTimeChange,
    onRefresh: () => {
      (0, _call_api.clearCache)();
      onTimeRangeRefresh();
    },
    onRefreshChange: ({
      isPaused: nextRefreshPaused,
      refreshInterval: nextRefreshInterval
    }) => {
      onRefreshChange({
        nextRefreshPaused,
        nextRefreshInterval
      });
    },
    showUpdateButton: true,
    commonlyUsedRanges: commonlyUsedRanges,
    width: 'auto',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 5
    }
  });
}