"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _observabilityAlertDetails = require("@kbn/observability-alert-details");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _latency_chart = require("../../../shared/charts/latency_chart");
var _latency_aggregation_type_select = require("../../../shared/charts/latency_chart/latency_aggregation_type_select");
var _timeseries_chart = require("../../../shared/charts/timeseries_chart");
var _helper = require("../../../shared/charts/transaction_charts/helper");
var _get_comparison_options = require("../../../shared/time_comparison/get_comparison_options");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _latency_chart_selectors = require("../../../../selectors/latency_chart_selectors");
var _latency_aggregation_types = require("../../../../../common/latency_aggregation_types");
var _helpers = require("./helpers");
var _document_type = require("../../../../../common/document_type");
var _use_preferred_data_source_and_bucket_size = require("../../../../hooks/use_preferred_data_source_and_bucket_size");
var _constants = require("./constants");
var _transaction_type_select = require("./transaction_type_select");
var _view_in_apm_button = require("./view_in_apm_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763553950588235374/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/ui_components/alert_details_app_section/latency_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function LatencyChart({
  alert,
  transactionType,
  transactionTypes,
  transactionName,
  serviceName,
  environment,
  start,
  end,
  latencyAggregationType,
  setLatencyAggregationType,
  setTransactionType,
  comparisonChartTheme,
  comparisonEnabled,
  offset,
  timeZone,
  customAlertEvaluationThreshold,
  kuery = '',
  filters,
  threshold
}) {
  const preferred = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery: '',
    numBuckets: 100,
    type: transactionName ? _document_type.ApmDocumentType.TransactionMetric : _document_type.ApmDocumentType.ServiceTransactionMetric
  });
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (serviceName && start && end && transactionType && latencyAggregationType && preferred) {
      return callApmApi(`GET /internal/apm/services/{serviceName}/transactions/charts/latency`, {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            filters: filters ? JSON.stringify(filters) : undefined,
            start,
            end,
            transactionType,
            transactionName,
            latencyAggregationType,
            documentType: preferred.source.documentType,
            rollupInterval: preferred.source.rollupInterval,
            bucketSizeInSeconds: preferred.bucketSizeInSeconds,
            useDurationSummary: preferred.source.hasDurationSummaryField && latencyAggregationType === _latency_aggregation_types.LatencyAggregationType.avg
          }
        }
      });
    }
  }, [end, environment, latencyAggregationType, serviceName, start, transactionType, transactionName, preferred, kuery, filters]);
  const alertEvalThreshold = customAlertEvaluationThreshold || alert.fields[_ruleDataUtils.ALERT_EVALUATION_THRESHOLD];
  const alertEnd = alert.fields[_ruleDataUtils.ALERT_END] ? (0, _moment.default)(alert.fields[_ruleDataUtils.ALERT_END]).valueOf() : undefined;
  const alertEvalThresholdChartData = alertEvalThreshold ? [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertThresholdTimeRangeRect, {
    key: 'alertThresholdRect',
    id: 'alertThresholdRect',
    threshold: alertEvalThreshold,
    color: euiTheme.colors.danger,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertThresholdAnnotation, {
    id: 'alertThresholdAnnotation',
    key: 'alertThresholdAnnotation',
    color: euiTheme.colors.danger,
    threshold: alertEvalThreshold,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  })] : [];
  const getLatencyChartAdditionalData = () => {
    if ((0, _helpers.isLatencyThresholdRuleType)(alert.fields[_ruleDataUtils.ALERT_RULE_TYPE_ID]) || customAlertEvaluationThreshold) {
      return [/*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertActiveTimeRangeAnnotation, {
        alertStart: alert.start,
        alertEnd: alertEnd,
        color: euiTheme.colors.danger,
        id: 'alertActiveRect',
        key: 'alertActiveRect',
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 167,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_observabilityAlertDetails.AlertAnnotation, {
        key: 'alertAnnotationStart',
        id: 'alertAnnotationStart',
        alertStart: alert.start,
        color: euiTheme.colors.danger,
        dateFormat: uiSettings && uiSettings.get(_public2.UI_SETTINGS.DATE_FORMAT) || _constants.DEFAULT_DATE_FORMAT,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 9
        }
      }), ...alertEvalThresholdChartData];
    }
  };
  const memoizedData = (0, _react.useMemo)(() => (0, _latency_chart_selectors.getLatencyChartSelector)({
    latencyChart: data,
    latencyAggregationType,
    previousPeriodLabel: ''
  }), [data, latencyAggregationType]);
  const {
    currentPeriod,
    previousPeriod
  } = memoizedData;
  const timeseriesLatency = [currentPeriod, comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? previousPeriod : undefined].filter(_latency_chart.filterNil);
  const latencyMaxY = (0, _helper.getMaxY)(timeseriesLatency);
  const latencyFormatter = (0, _common.getDurationFormatter)(latencyMaxY);
  const showTransactionTypeSelect = transactionTypes && setTransactionType;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.apm.dependencyLatencyChart.chartTitle', {
    defaultMessage: 'Latency'
  })))), setLatencyAggregationType && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_aggregation_type_select.LatencyAggregationTypeSelect, {
    latencyAggregationType: latencyAggregationType,
    onChange: setLatencyAggregationType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 15
    }
  })), showTransactionTypeSelect && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_type_select.TransactionTypeSelect, {
    transactionType: transactionType,
    transactionTypes: transactionTypes,
    onChange: setTransactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_view_in_apm_button.ViewInAPMButton, {
    serviceName: serviceName,
    environment: environment,
    from: start,
    to: end,
    kuery: kuery,
    transactionName: transactionName,
    transactionType: transactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 9
    }
  }, !!threshold && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 180
    },
    grow: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 13
    }
  }, threshold), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: !!threshold ? 5 : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_timeseries_chart.TimeseriesChart, {
    id: "latencyChart",
    annotations: getLatencyChartAdditionalData(),
    height: 200,
    comparisonEnabled: comparisonEnabled,
    offset: offset,
    fetchStatus: status,
    customTheme: comparisonChartTheme,
    timeseries: timeseriesLatency,
    yLabelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    timeZone: timeZone,
    settings: _constants.CHART_SETTINGS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  })))));
}

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LatencyChart;
module.exports = exports.default;