/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class LazyFileOutputStream
extends OutputStream {
    private final File file;
    private volatile OutputStream delegate;
    private volatile boolean initialized = false;
    private final Object lock = new Object();

    LazyFileOutputStream(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized() throws IOException {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    this.file.getParentFile().mkdirs();
                    this.delegate = new FileOutputStream(this.file);
                    this.initialized = true;
                }
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureInitialized();
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.ensureInitialized();
        this.delegate.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.ensureInitialized();
        this.delegate.write(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.initialized && this.delegate != null) {
                this.delegate.close();
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.initialized && this.delegate != null) {
            this.delegate.flush();
        }
    }
}

