/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.AbstractBigByteArray;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;

final class BigLongArray
extends AbstractBigByteArray
implements LongArray {
    private static final BigLongArray ESTIMATOR = new BigLongArray(0L, BigArrays.NON_RECYCLING_INSTANCE, false);
    static final VarHandle VH_PLATFORM_NATIVE_LONG = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.nativeOrder());
    private static final int PAGE_SHIFT = Integer.numberOfTrailingZeros(2048);

    BigLongArray(long size, BigArrays bigArrays, boolean clearOnResize) {
        super(2048, bigArrays, clearOnResize, size);
    }

    @Override
    public long get(long index) {
        int pageIndex = BigLongArray.pageIdx(index);
        int indexInPage = BigLongArray.idxInPage(index);
        return VH_PLATFORM_NATIVE_LONG.get(this.pages[pageIndex], indexInPage << 3);
    }

    @Override
    public long getAndSet(long index, long value) {
        int pageIndex = BigLongArray.pageIdx(index);
        int indexInPage = BigLongArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        long ret = VH_PLATFORM_NATIVE_LONG.get(page, indexInPage << 3);
        VH_PLATFORM_NATIVE_LONG.set(page, indexInPage << 3, value);
        return ret;
    }

    @Override
    public void set(long index, long value) {
        int pageIndex = BigLongArray.pageIdx(index);
        int indexInPage = BigLongArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        VH_PLATFORM_NATIVE_LONG.set(page, indexInPage << 3, value);
    }

    @Override
    public long increment(long index, long inc) {
        int pageIndex = BigLongArray.pageIdx(index);
        int indexInPage = BigLongArray.idxInPage(index);
        byte[] page = this.getPageForWriting(pageIndex);
        long newVal = VH_PLATFORM_NATIVE_LONG.get(page, indexInPage << 3) + inc;
        VH_PLATFORM_NATIVE_LONG.set(page, indexInPage << 3, newVal);
        return newVal;
    }

    @Override
    protected int numBytesPerElement() {
        return 8;
    }

    @Override
    public void fill(long fromIndex, long toIndex, long value) {
        int toPage;
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (fromIndex == toIndex) {
            return;
        }
        int fromPage = BigLongArray.pageIdx(fromIndex);
        if (fromPage == (toPage = BigLongArray.pageIdx(toIndex - 1L))) {
            BigLongArray.fill(this.getPageForWriting(fromPage), BigLongArray.idxInPage(fromIndex), BigLongArray.idxInPage(toIndex - 1L) + 1, value);
        } else {
            BigLongArray.fill(this.getPageForWriting(fromPage), BigLongArray.idxInPage(fromIndex), 2048, value);
            for (int i = fromPage + 1; i < toPage; ++i) {
                BigLongArray.fill(this.getPageForWriting(i), 0, 2048, value);
            }
            BigLongArray.fill(this.getPageForWriting(toPage), 0, BigLongArray.idxInPage(toIndex - 1L) + 1, value);
        }
    }

    public static void fill(byte[] page, int from, int to, long value) {
        if (from < to) {
            VH_PLATFORM_NATIVE_LONG.set(page, from << 3, value);
            BigLongArray.fillBySelfCopy(page, from << 3, to << 3, 8);
        }
    }

    public static long estimateRamBytes(long size) {
        return ESTIMATOR.ramBytesEstimated(size);
    }

    @Override
    public void set(long index, byte[] buf, int offset, int len) {
        this.set(index, buf, offset, len, 3);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        BigLongArray.writePages(out, this.size, this.pages, 8);
    }

    @Override
    public void fillWith(StreamInput in) throws IOException {
        this.readPages(in);
    }

    static void writePages(StreamOutput out, long size, byte[][] pages, int bytesPerValue) throws IOException {
        int len;
        int remainedBytes = Math.toIntExact(size * (long)bytesPerValue);
        out.writeVInt(remainedBytes);
        for (int i = 0; i < pages.length && remainedBytes > 0; remainedBytes -= len, ++i) {
            len = Math.min(remainedBytes, pages[i].length);
            out.writeBytes(pages[i], 0, len);
        }
    }

    private static int pageIdx(long index) {
        return (int)(index >>> PAGE_SHIFT);
    }

    private static int idxInPage(long index) {
        return (int)(index & 0x7FFL);
    }
}

