/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterStateAckListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Priority;
import org.elasticsearch.core.TimeValue;

public abstract class AckedClusterStateUpdateTask
extends ClusterStateUpdateTask
implements ClusterStateAckListener {
    private final ActionListener<AcknowledgedResponse> listener;
    private final TimeValue ackTimeout;

    protected AckedClusterStateUpdateTask(AcknowledgedRequest<?> request, ActionListener<? extends AcknowledgedResponse> listener) {
        this(Priority.NORMAL, request.masterNodeTimeout(), request.ackTimeout(), listener);
    }

    protected AckedClusterStateUpdateTask(TimeValue masterNodeTimeout, TimeValue ackTimeout, ActionListener<? extends AcknowledgedResponse> listener) {
        this(Priority.NORMAL, masterNodeTimeout, ackTimeout, listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, AcknowledgedRequest<?> request, ActionListener<? extends AcknowledgedResponse> listener) {
        this(priority, request.masterNodeTimeout(), request.ackTimeout(), listener);
    }

    protected AckedClusterStateUpdateTask(Priority priority, TimeValue masterNodeTimeout, TimeValue ackTimeout, ActionListener<? extends AcknowledgedResponse> listener) {
        super(priority, masterNodeTimeout);
        this.listener = listener;
        this.ackTimeout = Objects.requireNonNull(ackTimeout);
    }

    @Override
    public boolean mustAck(DiscoveryNode discoveryNode) {
        return true;
    }

    @Override
    public void onAllNodesAcked() {
        this.listener.onResponse(this.newResponse(true));
    }

    @Override
    public void onAckFailure(Exception e) {
        this.listener.onResponse(this.newResponse(false));
    }

    protected AcknowledgedResponse newResponse(boolean acknowledged) {
        return AcknowledgedResponse.of(acknowledged);
    }

    @Override
    public void onAckTimeout() {
        this.listener.onResponse(this.newResponse(false));
    }

    @Override
    public void onFailure(Exception e) {
        this.listener.onFailure(e);
    }

    @Override
    public final TimeValue ackTimeout() {
        return this.ackTimeout;
    }
}

