/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.get;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.local.TransportLocalProjectMetadataAction;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetMappingsAction
extends TransportLocalProjectMetadataAction<GetMappingsRequest, GetMappingsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetMappingsAction.class);
    private final IndicesService indicesService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetMappingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, IndicesService indicesService, ProjectResolver projectResolver) {
        super("indices:admin/mappings/get", actionFilters, transportService.getTaskManager(), clusterService, threadPool.executor("management"), projectResolver);
        this.indicesService = indicesService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(this.actionName, this.executor, false, true, GetMappingsRequest::new, (request, channel, task) -> this.executeDirect(task, request, new ChannelActionListener(channel)));
    }

    @Override
    protected ClusterBlockException checkBlock(GetMappingsRequest request, ProjectState state) {
        return state.blocks().indicesBlockedException(state.projectId(), ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state.metadata(), (IndicesRequest)request));
    }

    @Override
    protected void localClusterStateOperation(Task task, GetMappingsRequest request, ProjectState state, ActionListener<GetMappingsResponse> listener) {
        ((CancellableTask)task).ensureNotCancelled();
        logger.trace("serving getMapping request based on version {}", (Object)state.cluster().version());
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state.metadata(), (IndicesRequest)request);
        Map<String, MappingMetadata> mappings = state.metadata().findMappings(concreteIndices, this.indicesService.getFieldFilter(), () -> TransportGetMappingsAction.checkCancellation(task));
        listener.onResponse(new GetMappingsResponse(mappings));
    }

    private static void checkCancellation(Task task) {
        if (task instanceof CancellableTask) {
            CancellableTask cancellableTask = (CancellableTask)task;
            cancellableTask.ensureNotCancelled();
        }
    }
}

