/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.StdDevFloatAggregator;
import org.elasticsearch.compute.aggregation.StdDevStates;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class StdDevFloatAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("mean", ElementType.DOUBLE), new IntermediateStateDesc("m2", ElementType.DOUBLE), new IntermediateStateDesc("count", ElementType.LONG));
    private final DriverContext driverContext;
    private final StdDevStates.SingleState state;
    private final List<Integer> channels;

    public StdDevFloatAggregatorFunction(DriverContext driverContext, List<Integer> channels, StdDevStates.SingleState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static StdDevFloatAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new StdDevFloatAggregatorFunction(driverContext, channels, StdDevFloatAggregator.initSingle());
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (!mask.allFalse()) {
            if (mask.allTrue()) {
                this.addRawInputNotMasked(page);
            } else {
                this.addRawInputMasked(page, mask);
            }
        }
    }

    private void addRawInputMasked(Page page, BooleanVector mask) {
        FloatBlock valueBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock, mask);
            return;
        }
        this.addRawVector(valueVector, mask);
    }

    private void addRawInputNotMasked(Page page) {
        FloatBlock valueBlock = (FloatBlock)page.getBlock(this.channels.get(0));
        FloatVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.addRawBlock(valueBlock);
            return;
        }
        this.addRawVector(valueVector);
    }

    private void addRawVector(FloatVector valueVector) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            float valueValue = valueVector.getFloat(valuesPosition);
            StdDevFloatAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawVector(FloatVector valueVector, BooleanVector mask) {
        for (int valuesPosition = 0; valuesPosition < valueVector.getPositionCount(); ++valuesPosition) {
            if (!mask.getBoolean(valuesPosition)) continue;
            float valueValue = valueVector.getFloat(valuesPosition);
            StdDevFloatAggregator.combine(this.state, valueValue);
        }
    }

    private void addRawBlock(FloatBlock valueBlock) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (valueBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                float valueValue = valueBlock.getFloat(valueOffset);
                StdDevFloatAggregator.combine(this.state, valueValue);
            }
        }
    }

    private void addRawBlock(FloatBlock valueBlock, BooleanVector mask) {
        for (int p = 0; p < valueBlock.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || valueBlock.isNull(p)) continue;
            int valueStart = valueBlock.getFirstValueIndex(p);
            int valueEnd = valueStart + valueBlock.getValueCount(p);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                float valueValue = valueBlock.getFloat(valueOffset);
                StdDevFloatAggregator.combine(this.state, valueValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + StdDevFloatAggregatorFunction.intermediateStateDesc().size());
        Object meanUncast = page.getBlock(this.channels.get(0));
        if (meanUncast.areAllValuesNull()) {
            return;
        }
        DoubleVector mean = ((DoubleBlock)meanUncast).asVector();
        assert (mean.getPositionCount() == 1);
        Object m2Uncast = page.getBlock(this.channels.get(1));
        if (m2Uncast.areAllValuesNull()) {
            return;
        }
        DoubleVector m2 = ((DoubleBlock)m2Uncast).asVector();
        assert (m2.getPositionCount() == 1);
        Object countUncast = page.getBlock(this.channels.get(2));
        if (countUncast.areAllValuesNull()) {
            return;
        }
        LongVector count = ((LongBlock)countUncast).asVector();
        assert (count.getPositionCount() == 1);
        StdDevFloatAggregator.combineIntermediate(this.state, mean.getDouble(0), m2.getDouble(0), count.getLong(0));
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        blocks[offset] = StdDevFloatAggregator.evaluateFinal(this.state, driverContext);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

