/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.utils;

import java.util.regex.Pattern;

public final class TransformStrings {
    private static final Pattern VALID_ID_CHAR_PATTERN = Pattern.compile("[a-z0-9](?:[a-z0-9_\\-\\.]*[a-z0-9])?");
    public static final int ID_LENGTH_LIMIT = 64;

    private TransformStrings() {
    }

    public static boolean isValidId(String id) {
        return id != null && VALID_ID_CHAR_PATTERN.matcher(id).matches() && !"_all".equals(id);
    }

    public static boolean hasValidLengthForId(String id) {
        return id.length() <= 64;
    }
}

