/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.index.Index;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.ilm.ClusterStateActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class DownsamplePrepareLifeCycleStateStep
extends ClusterStateActionStep {
    private static final Logger LOGGER = LogManager.getLogger(DownsamplePrepareLifeCycleStateStep.class);
    public static final String NAME = "generate-downsampled-index-name";
    private final DateHistogramInterval fixedInterval;

    public DownsamplePrepareLifeCycleStateStep(Step.StepKey key, Step.StepKey nextStepKey, DateHistogramInterval fixedInterval) {
        super(key, nextStepKey);
        this.fixedInterval = fixedInterval;
    }

    @Override
    public ProjectState performAction(Index index, ProjectState projectState) {
        IndexMetadata indexMetadata = projectState.metadata().index(index);
        if (indexMetadata == null) {
            LOGGER.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().action(), (Object)index.getName());
            return projectState;
        }
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        LifecycleExecutionState.Builder newLifecycleState = LifecycleExecutionState.builder((LifecycleExecutionState)lifecycleState);
        String downsampleIndexName = DownsampleConfig.generateDownsampleIndexName((String)"downsample-", (IndexMetadata)indexMetadata, (DateHistogramInterval)this.fixedInterval);
        newLifecycleState.setDownsampleIndexName(downsampleIndexName);
        return projectState.updateProject(projectState.metadata().withLifecycleState(indexMetadata.getIndex(), newLifecycleState.build()));
    }

    @Override
    public boolean isRetryable() {
        return true;
    }
}

