/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.compute.operator.DriverCompletionInfo;
import org.elasticsearch.compute.operator.exchange.ExchangeService;
import org.elasticsearch.compute.operator.exchange.ExchangeSinkHandler;
import org.elasticsearch.compute.operator.exchange.ExchangeSourceHandler;
import org.elasticsearch.compute.operator.exchange.RemoteSink;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.esql.action.EsqlExecutionInfo;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeSinkExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.plugin.ClusterComputeRequest;
import org.elasticsearch.xpack.esql.plugin.ComputeContext;
import org.elasticsearch.xpack.esql.plugin.ComputeListener;
import org.elasticsearch.xpack.esql.plugin.ComputeResponse;
import org.elasticsearch.xpack.esql.plugin.ComputeService;
import org.elasticsearch.xpack.esql.plugin.DataNodeComputeHandler;
import org.elasticsearch.xpack.esql.plugin.EsqlFlags;
import org.elasticsearch.xpack.esql.plugin.QueryPragmas;
import org.elasticsearch.xpack.esql.plugin.RemoteClusterPlan;
import org.elasticsearch.xpack.esql.session.Configuration;
import org.elasticsearch.xpack.esql.session.EsqlCCSUtils;

final class ClusterComputeHandler
implements TransportRequestHandler<ClusterComputeRequest> {
    private final ComputeService computeService;
    private final ExchangeService exchangeService;
    private final TransportService transportService;
    private final Executor esqlExecutor;
    private final DataNodeComputeHandler dataNodeComputeHandler;

    ClusterComputeHandler(ComputeService computeService, ExchangeService exchangeService, TransportService transportService, Executor esqlExecutor, DataNodeComputeHandler dataNodeComputeHandler) {
        this.computeService = computeService;
        this.exchangeService = exchangeService;
        this.esqlExecutor = esqlExecutor;
        this.transportService = transportService;
        this.dataNodeComputeHandler = dataNodeComputeHandler;
        transportService.registerRequestHandler("indices:data/read/esql/cluster", esqlExecutor, ClusterComputeRequest::new, (TransportRequestHandler)this);
    }

    void startComputeOnRemoteCluster(String sessionId, CancellableTask rootTask, Configuration configuration, PhysicalPlan plan, ExchangeSourceHandler exchangeSource, RemoteCluster cluster, Runnable cancelQueryOnFailure, EsqlExecutionInfo executionInfo, ActionListener<DriverCompletionInfo> listener) {
        QueryPragmas queryPragmas = configuration.pragmas();
        listener = ActionListener.runBefore(listener, () -> ((Releasable)exchangeSource.addEmptySink()).close());
        String childSessionId = this.computeService.newChildSession(sessionId);
        String clusterAlias = cluster.clusterAlias();
        AtomicBoolean pagesFetched = new AtomicBoolean();
        AtomicReference finalResponse = new AtomicReference();
        listener = listener.delegateResponse((l, e) -> {
            boolean receivedResults;
            boolean bl = receivedResults = finalResponse.get() != null || pagesFetched.get();
            if (executionInfo.shouldSkipOnFailure(clusterAlias) || configuration.allowPartialResults() && EsqlCCSUtils.canAllowPartial(e)) {
                EsqlCCSUtils.markClusterWithFinalStateAndNoShards(executionInfo, clusterAlias, receivedResults ? EsqlExecutionInfo.Cluster.Status.PARTIAL : EsqlExecutionInfo.Cluster.Status.SKIPPED, e);
                l.onResponse((Object)DriverCompletionInfo.EMPTY);
            } else {
                l.onFailure(e);
            }
        });
        ExchangeService.openExchange((TransportService)this.transportService, (Transport.Connection)cluster.connection, (String)childSessionId, (int)queryPragmas.exchangeBufferSize(), (Executor)this.esqlExecutor, (ActionListener)listener.delegateFailure((l, unused) -> {
            Runnable onGroupFailure;
            CancellableTask groupTask;
            boolean failFast;
            boolean bl = failFast = !executionInfo.shouldSkipOnFailure(clusterAlias) && !configuration.allowPartialResults();
            if (failFast) {
                groupTask = rootTask;
                onGroupFailure = cancelQueryOnFailure;
            } else {
                try {
                    groupTask = this.computeService.createGroupTask((Task)rootTask, () -> "compute group: cluster [" + clusterAlias + "]");
                }
                catch (TaskCancelledException e) {
                    l.onFailure((Exception)((Object)e));
                    return;
                }
                onGroupFailure = this.computeService.cancelQueryOnFailure(groupTask);
                l = ActionListener.runAfter((ActionListener)l, () -> this.transportService.getTaskManager().unregister((Task)groupTask));
            }
            try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), onGroupFailure, (ActionListener<DriverCompletionInfo>)l.map(completionInfo -> {
                this.updateExecutionInfo(executionInfo, clusterAlias, (ComputeResponse)((Object)((Object)((Object)finalResponse.get()))));
                return completionInfo;
            }));){
                RemoteClusterPlan remotePlan = new RemoteClusterPlan(plan, cluster.concreteIndices, cluster.originalIndices);
                ClusterComputeRequest clusterRequest = new ClusterComputeRequest(clusterAlias, childSessionId, configuration, remotePlan);
                ActionListener clusterListener = computeListener.acquireCompute().map(r -> {
                    finalResponse.set(r);
                    return r.getCompletionInfo();
                });
                this.transportService.sendChildRequest(cluster.connection, "indices:data/read/esql/cluster", (TransportRequest)clusterRequest, (Task)groupTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(clusterListener, ComputeResponse::new, this.esqlExecutor));
                RemoteSink remoteSink = this.exchangeService.newRemoteSink((Task)groupTask, childSessionId, this.transportService, cluster.connection);
                exchangeSource.addRemoteSink(remoteSink, failFast, () -> pagesFetched.set(true), queryPragmas.concurrentExchangeClients(), computeListener.acquireAvoid());
            }
        }));
    }

    private void updateExecutionInfo(EsqlExecutionInfo executionInfo, String clusterAlias, ComputeResponse resp) {
        executionInfo.swapCluster(clusterAlias, (k, v) -> {
            EsqlExecutionInfo.Cluster.Builder builder = new EsqlExecutionInfo.Cluster.Builder((EsqlExecutionInfo.Cluster)v);
            if (executionInfo.isMainPlan()) {
                builder.setTotalShards(resp.getTotalShards()).setSuccessfulShards(resp.getSuccessfulShards()).setSkippedShards(resp.getSkippedShards()).setFailedShards(resp.getFailedShards());
            }
            if (v.getTook() != null && resp.getTook() != null) {
                builder.setTook(TimeValue.timeValueNanos((long)(v.getTook().nanos() + resp.getTook().nanos())));
            } else if (resp.getTook() != null) {
                builder.setTook(TimeValue.timeValueNanos((long)(executionInfo.planningTookTime().nanos() + resp.getTook().nanos())));
            } else {
                builder.setTook(executionInfo.tookSoFar());
            }
            if (v.getStatus() == EsqlExecutionInfo.Cluster.Status.RUNNING) {
                builder.addFailures(v.getFailures());
                builder.addFailures(resp.failures);
                if (executionInfo.isMainPlan()) {
                    if (executionInfo.isStopped() || resp.failedShards > 0 || !resp.failures.isEmpty()) {
                        builder.setStatus(EsqlExecutionInfo.Cluster.Status.PARTIAL);
                    } else {
                        builder.setStatus(EsqlExecutionInfo.Cluster.Status.SUCCESSFUL);
                    }
                }
            }
            return builder.build();
        });
    }

    List<RemoteCluster> getRemoteClusters(Map<String, OriginalIndices> clusterToConcreteIndices, Map<String, OriginalIndices> clusterToOriginalIndices) {
        ArrayList<RemoteCluster> remoteClusters = new ArrayList<RemoteCluster>(clusterToConcreteIndices.size());
        RemoteClusterService remoteClusterService = this.transportService.getRemoteClusterService();
        for (Map.Entry<String, OriginalIndices> e : clusterToConcreteIndices.entrySet()) {
            String clusterAlias = e.getKey();
            OriginalIndices concreteIndices = clusterToConcreteIndices.get(clusterAlias);
            OriginalIndices originalIndices = clusterToOriginalIndices.get(clusterAlias);
            if (originalIndices == null) {
                assert (false) : "can't find original indices for cluster " + clusterAlias;
                throw new IllegalStateException("can't find original indices for cluster " + clusterAlias);
            }
            if (concreteIndices.indices().length <= 0) continue;
            Transport.Connection connection = remoteClusterService.getConnection(clusterAlias);
            remoteClusters.add(new RemoteCluster(clusterAlias, connection, concreteIndices.indices(), originalIndices));
        }
        return remoteClusters;
    }

    public void messageReceived(ClusterComputeRequest request, TransportChannel channel, Task task) {
        ChannelActionListener listener = new ChannelActionListener(channel);
        RemoteClusterPlan remoteClusterPlan = request.remoteClusterPlan();
        PhysicalPlan plan = remoteClusterPlan.plan();
        if (!(plan instanceof ExchangeSinkExec)) {
            listener.onFailure((Exception)new IllegalStateException("expected exchange sink for a remote compute; got " + String.valueOf((Object)plan)));
            return;
        }
        this.runComputeOnRemoteCluster(request.clusterAlias(), request.sessionId(), (CancellableTask)task, request.configuration(), (ExchangeSinkExec)plan, Set.of(remoteClusterPlan.targetIndices()), remoteClusterPlan.originalIndices(), (ActionListener<ComputeResponse>)listener);
    }

    void runComputeOnRemoteCluster(String clusterAlias, String globalSessionId, CancellableTask parentTask, Configuration configuration, ExchangeSinkExec plan, Set<String> concreteIndices, OriginalIndices originalIndices, ActionListener<ComputeResponse> listener) {
        ExchangeSinkHandler exchangeSink = this.exchangeService.getSinkHandler(globalSessionId);
        parentTask.addListener(() -> this.exchangeService.finishSinkHandler(globalSessionId, (Exception)((Object)new TaskCancelledException(parentTask.getReasonCancelled()))));
        String localSessionId = clusterAlias + ":" + globalSessionId;
        PhysicalPlan coordinatorPlan = ComputeService.reductionPlan(plan, true);
        AtomicReference finalResponse = new AtomicReference();
        EsqlFlags flags = this.computeService.createFlags();
        long startTimeInNanos = System.nanoTime();
        Runnable cancelQueryOnFailure = this.computeService.cancelQueryOnFailure(parentTask);
        try (ComputeListener computeListener = new ComputeListener(this.transportService.getThreadPool(), cancelQueryOnFailure, (ActionListener<DriverCompletionInfo>)listener.map(profiles -> {
            TimeValue took = TimeValue.timeValueNanos((long)(System.nanoTime() - startTimeInNanos));
            ComputeResponse r = (ComputeResponse)((Object)((Object)finalResponse.get()));
            return new ComputeResponse((DriverCompletionInfo)profiles, took, r.totalShards, r.successfulShards, r.skippedShards, r.failedShards, r.failures);
        }));){
            ExchangeSourceHandler exchangeSource = new ExchangeSourceHandler(configuration.pragmas().exchangeBufferSize(), (Executor)this.transportService.getThreadPool().executor("search"));
            try (Releasable ignored = exchangeSource.addEmptySink();){
                exchangeSink.addCompletionListener(computeListener.acquireAvoid());
                this.computeService.runCompute(parentTask, new ComputeContext(localSessionId, "remote_reduce", clusterAlias, flags, List.of(), configuration, configuration.newFoldContext(), () -> ((ExchangeSourceHandler)exchangeSource).createExchangeSource(), () -> exchangeSink.createExchangeSink(() -> {})), coordinatorPlan, computeListener.acquireCompute());
                this.dataNodeComputeHandler.startComputeOnDataNodes(localSessionId, clusterAlias, parentTask, flags, configuration, plan, concreteIndices, originalIndices, exchangeSource, cancelQueryOnFailure, (ActionListener<ComputeResponse>)computeListener.acquireCompute().map(r -> {
                    finalResponse.set(r);
                    return r.getCompletionInfo();
                }));
            }
        }
    }

    record RemoteCluster(String clusterAlias, Transport.Connection connection, String[] concreteIndices, OriginalIndices originalIndices) {
    }
}

