/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSResources;
import java.nio.file.Path;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedCuVSResources
implements CuVSResources {
    private final CuVSResources inner;
    private final ReentrantLock lock;

    private SynchronizedCuVSResources(CuVSResources inner) {
        this.inner = inner;
        this.lock = new ReentrantLock();
    }

    static CuVSResources create() throws Throwable {
        return new SynchronizedCuVSResources(CuVSResources.create());
    }

    @Override
    public CuVSResources.ScopedAccess access() {
        this.lock.lock();
        return new CuVSResources.ScopedAccess(){

            @Override
            public long handle() {
                return SynchronizedCuVSResources.this.inner.access().handle();
            }

            @Override
            public void close() {
                SynchronizedCuVSResources.this.lock.unlock();
            }
        };
    }

    @Override
    public int deviceId() {
        return this.inner.deviceId();
    }

    @Override
    public void close() {
        this.inner.close();
    }

    @Override
    public Path tempDirectory() {
        return this.inner.tempDirectory();
    }
}

