/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSIvfPqIndexParams;
import com.nvidia.cuvs.CuVSIvfPqSearchParams;

public class CuVSIvfPqParams {
    private final CuVSIvfPqIndexParams indexParams;
    private final CuVSIvfPqSearchParams searchParams;
    private final float refinementRate;

    private CuVSIvfPqParams(CuVSIvfPqIndexParams indexParams, CuVSIvfPqSearchParams searchParams, float refinementRate) {
        this.indexParams = indexParams;
        this.searchParams = searchParams;
        this.refinementRate = refinementRate;
    }

    public CuVSIvfPqIndexParams getIndexParams() {
        return this.indexParams;
    }

    public CuVSIvfPqSearchParams getSearchParams() {
        return this.searchParams;
    }

    public float getRefinementRate() {
        return this.refinementRate;
    }

    public String toString() {
        return "CuVSIvfPqParams [indexParams=" + String.valueOf(this.indexParams) + ", searchParams=" + String.valueOf(this.searchParams) + ", refinementRate=" + this.refinementRate + "]";
    }

    public static class Builder {
        private CuVSIvfPqIndexParams cuVSIvfPqIndexParams = new CuVSIvfPqIndexParams.Builder().build();
        private CuVSIvfPqSearchParams cuVSIvfPqSearchParams = new CuVSIvfPqSearchParams.Builder().build();
        private float refinementRate = 2.0f;

        public Builder withCuVSIvfPqIndexParams(CuVSIvfPqIndexParams cuVSIvfPqIndexParams) {
            this.cuVSIvfPqIndexParams = cuVSIvfPqIndexParams;
            return this;
        }

        public Builder withCuVSIvfPqSearchParams(CuVSIvfPqSearchParams cuVSIvfPqSearchParams) {
            this.cuVSIvfPqSearchParams = cuVSIvfPqSearchParams;
            return this;
        }

        public Builder withRefinementRate(float refinementRate) {
            this.refinementRate = refinementRate;
            return this;
        }

        public CuVSIvfPqParams build() {
            return new CuVSIvfPqParams(this.cuVSIvfPqIndexParams, this.cuVSIvfPqSearchParams, this.refinementRate);
        }
    }
}

