/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.inference.DequeUtils;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingChatCompletionResults;
import org.elasticsearch.xpack.core.inference.results.StreamingUnifiedChatCompletionResults;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedChatCompletionResponseHandler;
import org.elasticsearch.xpack.inference.services.openai.OpenAiUnifiedStreamingProcessor;
import org.elasticsearch.xpack.inference.services.sagemaker.model.SageMakerModel;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.SageMakerStreamSchemaPayload;
import org.elasticsearch.xpack.inference.services.sagemaker.schema.elastic.ElasticPayload;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.sagemakerruntime.model.InvokeEndpointResponse;

public class ElasticCompletionPayload
implements SageMakerStreamSchemaPayload,
ElasticPayload {
    private static final XContentParserConfiguration parserConfig = XContentParserConfiguration.EMPTY.withDeprecationHandler((DeprecationHandler)LoggingDeprecationHandler.INSTANCE);

    public ChatCompletionResults responseBody(SageMakerModel model, InvokeEndpointResponse response) throws Exception {
        try (XContentParser p = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, response.body().asInputStream());){
            ChatCompletionResults chatCompletionResults = (ChatCompletionResults)Completion.PARSER.apply(p, null);
            return chatCompletionResults;
        }
    }

    @Override
    public StreamingChatCompletionResults.Results streamResponseBody(SageMakerModel model, SdkBytes response) throws Exception {
        try (XContentParser p = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, response.asInputStream());){
            StreamingChatCompletionResults.Results results = (StreamingChatCompletionResults.Results)StreamCompletion.PARSER.apply(p, null);
            return results;
        }
    }

    @Override
    public SdkBytes chatCompletionRequestBytes(SageMakerModel model, UnifiedCompletionRequest request) {
        return SdkBytes.fromUtf8String((String)Strings.toString((builder, params) -> {
            request.toXContent(builder, UnifiedCompletionRequest.withMaxCompletionTokensTokens((ToXContent.Params)params));
            return builder;
        }));
    }

    @Override
    public StreamingUnifiedChatCompletionResults.Results chatCompletionResponseBody(SageMakerModel model, SdkBytes response) {
        String responseData = response.asUtf8String();
        try {
            ArrayDeque results = OpenAiUnifiedStreamingProcessor.parse(parserConfig, responseData).collect(() -> new ArrayDeque(), ArrayDeque::offer, ArrayDeque::addAll);
            return new StreamingUnifiedChatCompletionResults.Results((Deque)results);
        }
        catch (Exception e) {
            throw OpenAiUnifiedChatCompletionResponseHandler.buildMidStreamError(model.getInferenceEntityId(), responseData, e);
        }
    }

    private static class Completion {
        private static final ConstructingObjectParser<ChatCompletionResults, Void> PARSER = new ConstructingObjectParser(ChatCompletionResults.class.getSimpleName(), false, args -> new ChatCompletionResults((List)args[0]));
        private static final ConstructingObjectParser<ChatCompletionResults.Result, Void> RESULT_PARSER = new ConstructingObjectParser(ChatCompletionResults.Result.class.getSimpleName(), false, args -> new ChatCompletionResults.Result((String)args[0]));

        private Completion() {
        }

        static {
            RESULT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("result", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> RESULT_PARSER.apply(arg_0, arg_1), new ParseField(ChatCompletionResults.COMPLETION, new String[0]));
        }
    }

    private static class StreamCompletion {
        private static final ConstructingObjectParser<StreamingChatCompletionResults.Results, Void> PARSER = new ConstructingObjectParser(StreamingChatCompletionResults.Results.class.getSimpleName(), false, args -> new StreamingChatCompletionResults.Results((Deque)args[0]));
        private static final ConstructingObjectParser<StreamingChatCompletionResults.Result, Void> RESULT_PARSER = new ConstructingObjectParser(StreamingChatCompletionResults.Result.class.getSimpleName(), false, args -> new StreamingChatCompletionResults.Result((String)args[0]));

        private StreamCompletion() {
        }

        static {
            RESULT_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("delta", new String[0]));
            PARSER.declareField(ConstructingObjectParser.constructorArg(), (p, c) -> {
                XContentParser.Token token;
                XContentParser.Token currentToken = p.currentToken();
                if (currentToken.isValue() || currentToken == XContentParser.Token.VALUE_NULL || currentToken == XContentParser.Token.START_OBJECT) {
                    return DequeUtils.of((Object)((StreamingChatCompletionResults.Result)RESULT_PARSER.apply(p, c)));
                }
                ArrayDeque<StreamingChatCompletionResults.Result> deque = new ArrayDeque<StreamingChatCompletionResults.Result>();
                while ((token = p.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token.isValue() || token == XContentParser.Token.VALUE_NULL || token == XContentParser.Token.START_OBJECT) {
                        deque.offer((StreamingChatCompletionResults.Result)RESULT_PARSER.apply(p, c));
                        continue;
                    }
                    throw new IllegalStateException("expected value but got [" + String.valueOf(token) + "]");
                }
                return deque;
            }, new ParseField(ChatCompletionResults.COMPLETION, new String[0]), ObjectParser.ValueType.OBJECT_ARRAY);
        }
    }
}

