/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.request.completion;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.inference.UnifiedCompletionRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.external.http.sender.UnifiedChatInput;
import org.elasticsearch.xpack.inference.services.googlevertexai.completion.GoogleVertexAiChatCompletionTaskSettings;

public class GoogleModelGardenAnthropicChatCompletionRequestEntity
implements ToXContentObject {
    private static final String ANTHROPIC_VERSION = "anthropic_version";
    private static final String VERTEX_2023_10_16 = "vertex-2023-10-16";
    private static final String STREAM_FIELD = "stream";
    private static final String INPUT_SCHEMA_FIELD = "input_schema";
    public static final int DEFAULT_MAX_TOKENS = 1024;
    private final UnifiedCompletionRequest unifiedRequest;
    private final boolean stream;
    private final GoogleVertexAiChatCompletionTaskSettings taskSettings;

    public GoogleModelGardenAnthropicChatCompletionRequestEntity(UnifiedChatInput unifiedChatInput, GoogleVertexAiChatCompletionTaskSettings taskSettings) {
        this(Objects.requireNonNull(unifiedChatInput).getRequest(), Objects.requireNonNull(unifiedChatInput).stream(), Objects.requireNonNull(taskSettings));
    }

    public GoogleModelGardenAnthropicChatCompletionRequestEntity(UnifiedCompletionRequest unifiedRequest, boolean stream, GoogleVertexAiChatCompletionTaskSettings taskSettings) {
        this.unifiedRequest = Objects.requireNonNull(unifiedRequest);
        this.stream = stream;
        this.taskSettings = taskSettings;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        List tools;
        UnifiedCompletionRequest.ToolChoice toolChoice;
        builder.startObject();
        builder.field(ANTHROPIC_VERSION, VERTEX_2023_10_16);
        builder.field("messages", (Iterable)this.unifiedRequest.messages());
        if (this.unifiedRequest.temperature() != null) {
            builder.field("temperature", this.unifiedRequest.temperature());
        }
        if ((toolChoice = this.unifiedRequest.toolChoice()) != null) {
            if (toolChoice instanceof UnifiedCompletionRequest.ToolChoiceObject) {
                builder.startObject("tool_choice");
                builder.field("type", ((UnifiedCompletionRequest.ToolChoiceObject)toolChoice).type());
                builder.endObject();
            } else if (toolChoice instanceof UnifiedCompletionRequest.ToolChoiceString) {
                throw new ElasticsearchStatusException("Tool choice value is not supported as string by Google Model Garden Anthropic Chat Completion.", RestStatus.BAD_REQUEST, new Object[0]);
            }
        }
        if ((tools = this.unifiedRequest.tools()) != null && !tools.isEmpty()) {
            builder.startArray("tools");
            for (UnifiedCompletionRequest.Tool tool : tools) {
                UnifiedCompletionRequest.Tool.FunctionField function = tool.function();
                builder.startObject();
                builder.field("name", function.name());
                builder.field("description", function.description());
                Map parameters = function.parameters();
                if (parameters != null && !parameters.isEmpty()) {
                    builder.field(INPUT_SCHEMA_FIELD, parameters);
                }
                builder.endObject();
            }
            builder.endArray();
        }
        if (this.unifiedRequest.topP() != null) {
            builder.field("top_p", this.unifiedRequest.topP());
        }
        builder.field(STREAM_FIELD, this.stream);
        Number maxTokens = Objects.requireNonNullElse(this.unifiedRequest.maxCompletionTokens(), (Number)Objects.requireNonNullElse(this.taskSettings.maxTokens(), 1024));
        builder.field("max_tokens", maxTokens);
        builder.endObject();
        return builder;
    }
}

