/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.googlevertexai.completion;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ServiceUtils;

public class ThinkingConfig
implements Writeable,
ToXContentFragment {
    public static final String THINKING_CONFIG_FIELD = "thinking_config";
    public static final String THINKING_BUDGET_FIELD = "thinking_budget";
    private final Integer thinkingBudget;

    public ThinkingConfig() {
        this.thinkingBudget = null;
    }

    public ThinkingConfig(Integer thinkingBudget) {
        this.thinkingBudget = thinkingBudget;
    }

    public ThinkingConfig(StreamInput in) throws IOException {
        this.thinkingBudget = in.readOptionalVInt();
    }

    public static ThinkingConfig fromMap(Map<String, Object> map, ValidationException validationException) {
        Map<String, Object> thinkingConfigSettings = ServiceUtils.removeFromMapOrDefaultEmpty(map, THINKING_CONFIG_FIELD);
        Integer thinkingBudget = ServiceUtils.extractOptionalInteger(thinkingConfigSettings, THINKING_BUDGET_FIELD, "task_settings", validationException);
        return new ThinkingConfig(thinkingBudget);
    }

    public boolean isEmpty() {
        return this.thinkingBudget == null;
    }

    public Integer getThinkingBudget() {
        return this.thinkingBudget;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalVInt(this.thinkingBudget);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.thinkingBudget != null) {
            builder.startObject(THINKING_CONFIG_FIELD);
            builder.field(THINKING_BUDGET_FIELD, this.thinkingBudget);
            builder.endObject();
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThinkingConfig that = (ThinkingConfig)o;
        return Objects.equals(this.thinkingBudget, that.thinkingBudget);
    }

    public int hashCode() {
        return Objects.hashCode(this.thinkingBudget);
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }
}

