/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.anthropic.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SingleInputSenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.anthropic.AnthropicCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.anthropic.action.AnthropicActionVisitor;
import org.elasticsearch.xpack.inference.services.anthropic.completion.AnthropicChatCompletionModel;

public class AnthropicActionCreator
implements AnthropicActionVisitor {
    private static final String ERROR_PREFIX = "Anthropic chat completions";
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AnthropicActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AnthropicChatCompletionModel model, Map<String, Object> taskSettings) {
        AnthropicChatCompletionModel overriddenModel = AnthropicChatCompletionModel.of(model, taskSettings);
        AnthropicCompletionRequestManager requestCreator = AnthropicCompletionRequestManager.of(overriddenModel, this.serviceComponents.threadPool());
        String errorMessage = ActionUtils.constructFailedToSendRequestMessage(ERROR_PREFIX);
        return new SingleInputSenderExecutableAction(this.sender, requestCreator, errorMessage, ERROR_PREFIX);
    }
}

