/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AbstractAllocationDecision;
import org.elasticsearch.cluster.routing.allocation.AllocationDecision;
import org.elasticsearch.cluster.routing.allocation.ShardAllocationDecision;
import org.elasticsearch.common.ReferenceDocs;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public final class ClusterAllocationExplanation
implements ChunkedToXContentObject,
Writeable {
    static final String NO_SHARD_SPECIFIED_MESSAGE = Strings.format("No shard was specified in the explain API request, so this response explains a randomly chosen unassigned shard. There may be other unassigned shards in this cluster which cannot be assigned for different reasons. It may not be possible to assign this shard until one of the other shards is assigned correctly. To explain the allocation of other shards (whether assigned or unassigned) you must specify the target shard in the request to this API. See %s for more information.", new Object[]{ReferenceDocs.ALLOCATION_EXPLAIN_API});
    private final boolean specificShard;
    private final ShardRouting shardRouting;
    private final DiscoveryNode currentNode;
    private final DiscoveryNode relocationTargetNode;
    private final ClusterInfo clusterInfo;
    private final ShardAllocationDecision shardAllocationDecision;

    public ClusterAllocationExplanation(boolean specificShard, ShardRouting shardRouting, @Nullable DiscoveryNode currentNode, @Nullable DiscoveryNode relocationTargetNode, @Nullable ClusterInfo clusterInfo, ShardAllocationDecision shardAllocationDecision) {
        this.specificShard = specificShard;
        this.shardRouting = shardRouting;
        this.currentNode = currentNode;
        this.relocationTargetNode = relocationTargetNode;
        this.clusterInfo = clusterInfo;
        this.shardAllocationDecision = shardAllocationDecision;
    }

    public ClusterAllocationExplanation(StreamInput in) throws IOException {
        this.specificShard = in.readBoolean();
        this.shardRouting = new ShardRouting(in);
        this.currentNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.relocationTargetNode = in.readOptionalWriteable(DiscoveryNode::new);
        this.clusterInfo = in.readOptionalWriteable(ClusterInfo::new);
        this.shardAllocationDecision = new ShardAllocationDecision(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.specificShard);
        this.shardRouting.writeTo(out);
        out.writeOptionalWriteable(this.currentNode);
        out.writeOptionalWriteable(this.relocationTargetNode);
        out.writeOptionalWriteable(this.clusterInfo);
        this.shardAllocationDecision.writeTo(out);
    }

    public boolean isSpecificShard() {
        return this.specificShard;
    }

    public ShardId getShard() {
        return this.shardRouting.shardId();
    }

    public boolean isPrimary() {
        return this.shardRouting.primary();
    }

    public ShardRoutingState getShardState() {
        return this.shardRouting.state();
    }

    @Nullable
    public DiscoveryNode getCurrentNode() {
        return this.currentNode;
    }

    @Nullable
    public DiscoveryNode getRelocationTargetNode() {
        return this.relocationTargetNode;
    }

    @Nullable
    public UnassignedInfo getUnassignedInfo() {
        return this.shardRouting.unassignedInfo();
    }

    @Nullable
    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public ShardAllocationDecision getShardAllocationDecision() {
        return this.shardAllocationDecision;
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.chunk((builder, p) -> {
            builder.startObject();
            if (!this.isSpecificShard()) {
                builder.field("note", NO_SHARD_SPECIFIED_MESSAGE);
            }
            builder.field("index", this.shardRouting.getIndexName());
            builder.field("shard", this.shardRouting.getId());
            builder.field("primary", this.shardRouting.primary());
            builder.field("current_state", this.shardRouting.state().toString().toLowerCase(Locale.ROOT));
            if (this.shardRouting.unassignedInfo() != null) {
                ClusterAllocationExplanation.unassignedInfoToXContent(this.shardRouting.unassignedInfo(), builder);
            }
            if (this.currentNode != null) {
                builder.startObject("current_node");
                AbstractAllocationDecision.discoveryNodeToXContent(this.currentNode, true, builder);
                if (this.shardAllocationDecision.getMoveDecision().isDecisionTaken() && this.shardAllocationDecision.getMoveDecision().getCurrentNodeRanking() > 0) {
                    builder.field("weight_ranking", this.shardAllocationDecision.getMoveDecision().getCurrentNodeRanking());
                }
                builder.endObject();
            }
            return builder;
        }), this.clusterInfo != null ? ChunkedToXContentHelper.object("cluster_info", this.clusterInfo.toXContentChunked(params)) : Collections.emptyIterator(), this.getShardAllocationDecisionChunked(params), Iterators.single((builder, p) -> builder.endObject()));
    }

    private Iterator<? extends ToXContent> getShardAllocationDecisionChunked(ToXContent.Params params) {
        String explanation;
        if (this.shardAllocationDecision.isDecisionTaken()) {
            return this.shardAllocationDecision.toXContentChunked(params);
        }
        if (this.shardRouting.state() == ShardRoutingState.RELOCATING) {
            explanation = Strings.format("the shard is in the process of relocating from node [%s] to node [%s], wait until relocation has completed", this.currentNode.getName(), this.relocationTargetNode.getName());
        } else {
            assert (this.shardRouting.state() == ShardRoutingState.INITIALIZING);
            explanation = Strings.format("the shard is in the process of initializing on node [%s], wait until initialization has completed", this.currentNode.getName());
        }
        return Iterators.single((builder, p) -> builder.field("explanation", explanation));
    }

    private static void unassignedInfoToXContent(UnassignedInfo unassignedInfo, XContentBuilder builder) throws IOException {
        String details;
        builder.startObject("unassigned_info");
        builder.field("reason", (Enum)unassignedInfo.reason());
        builder.field("at", UnassignedInfo.DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(unassignedInfo.unassignedTimeMillis())));
        if (unassignedInfo.failedAllocations() > 0) {
            builder.field("failed_allocation_attempts", unassignedInfo.failedAllocations());
        }
        if ((details = unassignedInfo.details()) != null) {
            builder.field("details", details);
        }
        builder.field("last_allocation_status", (Enum)AllocationDecision.fromAllocationStatus(unassignedInfo.lastAllocationStatus()));
        builder.endObject();
    }
}

