/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.LongBigArrayBlock;
import org.elasticsearch.compute.data.LongBigArrayVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;

final class LongBlockBuilder
extends AbstractBlockBuilder
implements LongBlock.Builder {
    private long[] values;

    LongBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)initialSize * (long)this.elementSize());
        this.values = new long[initialSize];
    }

    @Override
    public LongBlockBuilder appendLong(long value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 8;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public LongBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public LongBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public LongBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public LongBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((LongBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public LongBlockBuilder copyFrom(LongBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        LongVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(LongBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.copyFrom(block, p);
        }
    }

    private void copyFromVector(LongVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendLong(vector.getLong(p));
        }
    }

    @Override
    public LongBlockBuilder copyFrom(LongBlock block, int position) {
        if (block.isNull(position)) {
            this.appendNull();
            return this;
        }
        int count = block.getValueCount(position);
        int i = block.getFirstValueIndex(position);
        if (count == 1) {
            this.appendLong(block.getLong(i++));
            return this;
        }
        this.beginPositionEntry();
        for (int v = 0; v < count; ++v) {
            this.appendLong(block.getLong(i++));
        }
        this.endPositionEntry();
        return this;
    }

    @Override
    public LongBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    private LongBlock buildBigArraysBlock() {
        LongArray array = this.blockFactory.bigArrays().newLongArray((long)this.valueCount, false);
        for (int i = 0; i < this.valueCount; ++i) {
            array.set((long)i, this.values[i]);
        }
        LongBlock theBlock = this.isDense() && this.singleValued() ? new LongBigArrayVector(array, this.positionCount, this.blockFactory).asBlock() : new LongBigArrayBlock(array, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
        this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - array.ramBytesUsed());
        return theBlock;
    }

    @Override
    public LongBlock build() {
        try {
            this.finish();
            LongBlock theBlock = this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1 ? this.blockFactory.newConstantLongBlockWith(this.values[0], 1, this.estimatedBytes) : (this.estimatedBytes > this.blockFactory.maxPrimitiveArrayBytes() ? this.buildBigArraysBlock() : (this.isDense() && this.singleValued() ? this.blockFactory.newLongArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newLongArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes)));
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

