/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data;

import java.util.Arrays;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.compute.data.AbstractBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BooleanBigArrayBlock;
import org.elasticsearch.compute.data.BooleanBigArrayVector;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;

final class BooleanBlockBuilder
extends AbstractBlockBuilder
implements BooleanBlock.Builder {
    private boolean[] values;

    BooleanBlockBuilder(int estimatedSize, BlockFactory blockFactory) {
        super(blockFactory);
        int initialSize = Math.max(estimatedSize, 2);
        this.adjustBreaker((long)RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + (long)initialSize * (long)this.elementSize());
        this.values = new boolean[initialSize];
    }

    @Override
    public BooleanBlockBuilder appendBoolean(boolean value) {
        this.ensureCapacity();
        this.values[this.valueCount] = value;
        this.hasNonNullValue = true;
        ++this.valueCount;
        this.updatePosition();
        return this;
    }

    @Override
    protected int elementSize() {
        return 1;
    }

    @Override
    protected int valuesLength() {
        return this.values.length;
    }

    @Override
    protected void growValuesArray(int newSize) {
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public BooleanBlockBuilder appendNull() {
        super.appendNull();
        return this;
    }

    @Override
    public BooleanBlockBuilder beginPositionEntry() {
        super.beginPositionEntry();
        return this;
    }

    @Override
    public BooleanBlockBuilder endPositionEntry() {
        super.endPositionEntry();
        return this;
    }

    @Override
    public BooleanBlockBuilder copyFrom(Block block, int beginInclusive, int endExclusive) {
        if (block.areAllValuesNull()) {
            for (int p = beginInclusive; p < endExclusive; ++p) {
                this.appendNull();
            }
            return this;
        }
        return this.copyFrom((BooleanBlock)block, beginInclusive, endExclusive);
    }

    @Override
    public BooleanBlockBuilder copyFrom(BooleanBlock block, int beginInclusive, int endExclusive) {
        if (endExclusive > block.getPositionCount()) {
            throw new IllegalArgumentException("can't copy past the end [" + endExclusive + " > " + block.getPositionCount() + "]");
        }
        BooleanVector vector = block.asVector();
        if (vector != null) {
            this.copyFromVector(vector, beginInclusive, endExclusive);
        } else {
            this.copyFromBlock(block, beginInclusive, endExclusive);
        }
        return this;
    }

    private void copyFromBlock(BooleanBlock block, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.copyFrom(block, p);
        }
    }

    private void copyFromVector(BooleanVector vector, int beginInclusive, int endExclusive) {
        for (int p = beginInclusive; p < endExclusive; ++p) {
            this.appendBoolean(vector.getBoolean(p));
        }
    }

    @Override
    public BooleanBlockBuilder copyFrom(BooleanBlock block, int position) {
        if (block.isNull(position)) {
            this.appendNull();
            return this;
        }
        int count = block.getValueCount(position);
        int i = block.getFirstValueIndex(position);
        if (count == 1) {
            this.appendBoolean(block.getBoolean(i++));
            return this;
        }
        this.beginPositionEntry();
        for (int v = 0; v < count; ++v) {
            this.appendBoolean(block.getBoolean(i++));
        }
        this.endPositionEntry();
        return this;
    }

    @Override
    public BooleanBlockBuilder mvOrdering(Block.MvOrdering mvOrdering) {
        this.mvOrdering = mvOrdering;
        return this;
    }

    private BooleanBlock buildBigArraysBlock() {
        BitArray array = new BitArray((long)this.valueCount, this.blockFactory.bigArrays());
        for (int i = 0; i < this.valueCount; ++i) {
            if (!this.values[i]) continue;
            array.set((long)i);
        }
        BooleanBlock theBlock = this.isDense() && this.singleValued() ? new BooleanBigArrayVector(array, this.positionCount, this.blockFactory).asBlock() : new BooleanBigArrayBlock(array, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.blockFactory);
        this.blockFactory.adjustBreaker(theBlock.ramBytesUsed() - this.estimatedBytes - array.ramBytesUsed());
        return theBlock;
    }

    @Override
    public BooleanBlock build() {
        try {
            this.finish();
            BooleanBlock theBlock = this.hasNonNullValue && this.positionCount == 1 && this.valueCount == 1 ? this.blockFactory.newConstantBooleanBlockWith(this.values[0], 1, this.estimatedBytes) : (this.estimatedBytes > this.blockFactory.maxPrimitiveArrayBytes() ? this.buildBigArraysBlock() : (this.isDense() && this.singleValued() ? this.blockFactory.newBooleanArrayVector(this.values, this.positionCount, this.estimatedBytes).asBlock() : this.blockFactory.newBooleanArrayBlock(this.values, this.positionCount, this.firstValueIndexes, this.nullsMask, this.mvOrdering, this.estimatedBytes)));
            this.built();
            return theBlock;
        }
        catch (CircuitBreakingException e) {
            this.close();
            throw e;
        }
    }
}

