/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.ResetMlComponentsAction;
import org.elasticsearch.xpack.ml.inference.TrainedModelStatsService;
import org.elasticsearch.xpack.ml.notifications.AnomalyDetectionAuditor;
import org.elasticsearch.xpack.ml.notifications.DataFrameAnalyticsAuditor;
import org.elasticsearch.xpack.ml.notifications.InferenceAuditor;

public class TransportResetMlComponentsAction
extends TransportNodesAction<ResetMlComponentsAction.Request, ResetMlComponentsAction.Response, ResetMlComponentsAction.NodeRequest, ResetMlComponentsAction.Response.ResetResponse, Void> {
    private final AnomalyDetectionAuditor anomalyDetectionAuditor;
    private final DataFrameAnalyticsAuditor dfaAuditor;
    private final InferenceAuditor inferenceAuditor;
    private final TrainedModelStatsService trainedModelStatsService;

    @Inject
    public TransportResetMlComponentsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, AnomalyDetectionAuditor anomalyDetectionAuditor, DataFrameAnalyticsAuditor dfaAuditor, InferenceAuditor inferenceAuditor, TrainedModelStatsService trainedModelStatsService) {
        super("cluster:internal/xpack/ml/auditor/reset", clusterService, transportService, actionFilters, ResetMlComponentsAction.NodeRequest::new, (Executor)threadPool.executor("management"));
        this.anomalyDetectionAuditor = anomalyDetectionAuditor;
        this.dfaAuditor = dfaAuditor;
        this.inferenceAuditor = inferenceAuditor;
        this.trainedModelStatsService = trainedModelStatsService;
    }

    protected ResetMlComponentsAction.Response newResponse(ResetMlComponentsAction.Request request, List<ResetMlComponentsAction.Response.ResetResponse> resetResponses, List<FailedNodeException> failures) {
        return new ResetMlComponentsAction.Response(this.clusterService.getClusterName(), resetResponses, failures);
    }

    protected ResetMlComponentsAction.NodeRequest newNodeRequest(ResetMlComponentsAction.Request request) {
        return new ResetMlComponentsAction.NodeRequest();
    }

    protected ResetMlComponentsAction.Response.ResetResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new ResetMlComponentsAction.Response.ResetResponse(in);
    }

    protected ResetMlComponentsAction.Response.ResetResponse nodeOperation(ResetMlComponentsAction.NodeRequest request, Task task) {
        this.anomalyDetectionAuditor.reset();
        this.dfaAuditor.reset();
        this.inferenceAuditor.reset();
        this.trainedModelStatsService.clearQueue();
        return new ResetMlComponentsAction.Response.ResetResponse(this.clusterService.localNode(), true);
    }
}

