/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVector;

public final class ToDenseVectorFromLongEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToDenseVectorFromLongEvaluator.class);
    private final EvalOperator.ExpressionEvaluator l;

    public ToDenseVectorFromLongEvaluator(Source source, EvalOperator.ExpressionEvaluator l, DriverContext driverContext) {
        super(driverContext, source);
        this.l = l;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.l;
    }

    @Override
    public Block evalVector(Vector v) {
        LongVector vector = (LongVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantFloatBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendFloat(this.evalValue(vector, p));
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(LongVector container, int index) {
        long value = container.getLong(index);
        return ToDenseVector.fromLong(value);
    }

    @Override
    public Block evalBlock(Block b) {
        LongBlock block = (LongBlock)b;
        int positionCount = block.getPositionCount();
        try (FloatBlock.Builder builder = this.driverContext.blockFactory().newFloatBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    float value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendFloat(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            FloatBlock floatBlock = builder.build();
            return floatBlock;
        }
    }

    private float evalValue(LongBlock container, int index) {
        long value = container.getLong(index);
        return ToDenseVector.fromLong(value);
    }

    public String toString() {
        return "ToDenseVectorFromLongEvaluator[l=" + String.valueOf(this.l) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.l);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.l.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory l;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory l) {
            this.source = source;
            this.l = l;
        }

        public ToDenseVectorFromLongEvaluator get(DriverContext context) {
            return new ToDenseVectorFromLongEvaluator(this.source, this.l.get(context), context);
        }

        public String toString() {
            return "ToDenseVectorFromLongEvaluator[l=" + String.valueOf(this.l) + "]";
        }
    }
}

