/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.execution;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.routing.Preference;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.watcher.execution.Wid;
import org.elasticsearch.xpack.core.watcher.watch.Watch;
import org.elasticsearch.xpack.watcher.execution.TriggeredWatch;
import org.elasticsearch.xpack.watcher.watch.WatchStoreUtils;

public class TriggeredWatchStore {
    private static final Logger logger = LogManager.getLogger(TriggeredWatchStore.class);
    private final int scrollSize;
    private final Client client;
    private final TimeValue scrollTimeout;
    private final TriggeredWatch.Parser triggeredWatchParser;
    private final TimeValue defaultBulkTimeout;
    private final TimeValue defaultSearchTimeout;
    private final BulkProcessor2 bulkProcessor;

    public TriggeredWatchStore(Settings settings, Client client, TriggeredWatch.Parser triggeredWatchParser, BulkProcessor2 bulkProcessor) {
        this.scrollSize = settings.getAsInt("xpack.watcher.execution.scroll.size", Integer.valueOf(1000));
        this.client = ClientHelper.clientWithOrigin((Client)client, (String)"watcher");
        this.scrollTimeout = settings.getAsTime("xpack.watcher.execution.scroll.timeout", TimeValue.timeValueMinutes((long)5L));
        this.defaultBulkTimeout = settings.getAsTime("xpack.watcher.internal.ops.bulk.default_timeout", TimeValue.timeValueSeconds((long)120L));
        this.defaultSearchTimeout = settings.getAsTime("xpack.watcher.internal.ops.search.default_timeout", TimeValue.timeValueSeconds((long)30L));
        this.triggeredWatchParser = triggeredWatchParser;
        this.bulkProcessor = bulkProcessor;
    }

    public void putAll(List<TriggeredWatch> triggeredWatches, ActionListener<BulkResponse> listener) throws IOException {
        if (triggeredWatches.isEmpty()) {
            listener.onResponse((Object)new BulkResponse(new BulkItemResponse[0], 0L));
            return;
        }
        this.client.bulk(TriggeredWatchStore.createBulkRequest(triggeredWatches), listener);
    }

    public BulkResponse putAll(List<TriggeredWatch> triggeredWatches) throws IOException {
        PlainActionFuture future = new PlainActionFuture();
        this.putAll(triggeredWatches, (ActionListener<BulkResponse>)future);
        return (BulkResponse)future.actionGet(this.defaultBulkTimeout);
    }

    private static BulkRequest createBulkRequest(List<TriggeredWatch> triggeredWatches) throws IOException {
        BulkRequest request = new BulkRequest();
        for (TriggeredWatch triggeredWatch : triggeredWatches) {
            IndexRequest indexRequest = new IndexRequest(".triggered_watches").id(triggeredWatch.id().value());
            try (XContentBuilder builder = XContentFactory.jsonBuilder();){
                triggeredWatch.toXContent(builder, ToXContent.EMPTY_PARAMS);
                indexRequest.source(builder);
            }
            indexRequest.opType(DocWriteRequest.OpType.CREATE);
            request.add(indexRequest);
        }
        return request;
    }

    public void delete(Wid wid) {
        DeleteRequest request = new DeleteRequest(".triggered_watches", wid.value());
        this.bulkProcessor.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TriggeredWatch> findTriggeredWatches(Collection<Watch> watches, ClusterState clusterState) {
        if (watches.isEmpty()) {
            return Collections.emptyList();
        }
        IndexMetadata indexMetadata = WatchStoreUtils.getConcreteIndex(".triggered_watches", clusterState.metadata());
        if (indexMetadata == null) {
            return Collections.emptyList();
        }
        try {
            RefreshRequest request = new RefreshRequest(new String[]{".triggered_watches"});
            this.client.admin().indices().refresh(request).actionGet(TimeValue.timeValueSeconds((long)5L));
        }
        catch (IndexNotFoundException e) {
            return Collections.emptyList();
        }
        Set ids = watches.stream().map(Watch::id).collect(Collectors.toSet());
        ArrayList<TriggeredWatch> triggeredWatches = new ArrayList<TriggeredWatch>(ids.size());
        SearchRequest searchRequest = new SearchRequest(new String[]{".triggered_watches"}).scroll(this.scrollTimeout).preference(Preference.LOCAL.toString()).source(new SearchSourceBuilder().size(this.scrollSize).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).version(Boolean.valueOf(true)));
        SearchResponse response = null;
        try {
            response = (SearchResponse)this.client.search(searchRequest).actionGet(this.defaultSearchTimeout);
            logger.debug("trying to find triggered watches for ids {}: found [{}] docs", ids, (Object)response.getHits().getTotalHits().value());
            while (response.getHits().getHits().length != 0) {
                for (SearchHit hit : response.getHits()) {
                    Wid wid = new Wid(hit.getId());
                    if (!ids.contains(wid.watchId())) continue;
                    TriggeredWatch triggeredWatch = this.triggeredWatchParser.parse(hit.getId(), hit.getVersion(), hit.getSourceRef());
                    triggeredWatches.add(triggeredWatch);
                }
                SearchScrollRequest request = new SearchScrollRequest(response.getScrollId());
                request.scroll(this.scrollTimeout);
                response.decRef();
                response = (SearchResponse)this.client.searchScroll(request).actionGet(this.defaultSearchTimeout);
            }
        }
        finally {
            if (response != null) {
                String scrollId = response.getScrollId();
                response.decRef();
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(scrollId);
                this.client.clearScroll(clearScrollRequest).actionGet(this.scrollTimeout);
            }
        }
        return triggeredWatches;
    }

    public static boolean validate(ClusterState state) {
        IndexMetadata indexMetadata = WatchStoreUtils.getConcreteIndex(".triggered_watches", state.metadata());
        return indexMetadata == null || indexMetadata.getState() == IndexMetadata.State.OPEN && state.routingTable(ProjectId.DEFAULT).index(indexMetadata.getIndex()).allPrimaryShardsActive();
    }
}

