/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.contextualai.rerank;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.inference.services.ConfigurationParseContext;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.contextualai.ContextualAiRateLimitServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.FilteredXContentObject;
import org.elasticsearch.xpack.inference.services.settings.RateLimitSettings;

public class ContextualAiRerankServiceSettings
extends FilteredXContentObject
implements ContextualAiRateLimitServiceSettings,
ServiceSettings {
    public static final String NAME = "contextualai_rerank_service_settings";
    private static final String API_KEY = "api_key";
    private static final String MODEL_ID = "model_id";
    private static final String DEFAULT_URL = "https://api.contextual.ai/v1/rerank";
    private static final RateLimitSettings DEFAULT_RATE_LIMIT_SETTINGS = new RateLimitSettings(1000L);
    private final URI uri;
    private final String modelId;
    private final RateLimitSettings rateLimitSettings;

    public static ContextualAiRerankServiceSettings fromMap(Map<String, Object> map, ConfigurationParseContext context) {
        ValidationException validationException = new ValidationException();
        String url = ServiceUtils.extractOptionalString(map, "url", "service_settings", validationException);
        String modelId = ServiceUtils.extractOptionalString(map, MODEL_ID, "service_settings", validationException);
        RateLimitSettings rateLimitSettings = RateLimitSettings.of(map, DEFAULT_RATE_LIMIT_SETTINGS, validationException, "contextualai", context);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        URI uri = url != null ? ServiceUtils.createUri(url) : ServiceUtils.createUri(DEFAULT_URL);
        return new ContextualAiRerankServiceSettings(uri, modelId, rateLimitSettings);
    }

    public ContextualAiRerankServiceSettings(URI uri, @Nullable String modelId, @Nullable RateLimitSettings rateLimitSettings) {
        this.uri = Objects.requireNonNull(uri);
        this.modelId = modelId;
        this.rateLimitSettings = Objects.requireNonNullElse(rateLimitSettings, DEFAULT_RATE_LIMIT_SETTINGS);
    }

    public ContextualAiRerankServiceSettings(StreamInput in) throws IOException {
        this.uri = ServiceUtils.createUri(in.readString());
        this.modelId = in.readString();
        this.rateLimitSettings = Objects.requireNonNullElse((RateLimitSettings)in.readOptionalWriteable(RateLimitSettings::new), DEFAULT_RATE_LIMIT_SETTINGS);
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public String modelId() {
        return this.modelId;
    }

    @Override
    public RateLimitSettings rateLimitSettings() {
        return this.rateLimitSettings;
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("url", this.uri.toString());
        builder.field(MODEL_ID, this.modelId);
        this.rateLimitSettings.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    @Override
    protected XContentBuilder toXContentFragmentOfExposedFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("url", this.uri.toString());
        builder.field(MODEL_ID, this.modelId);
        this.rateLimitSettings.toXContent(builder, params);
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uri.toString());
        out.writeString(this.modelId);
        out.writeOptionalWriteable((Writeable)this.rateLimitSettings);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ContextualAiRerankServiceSettings that = (ContextualAiRerankServiceSettings)object;
        return Objects.equals(this.uri, that.uri) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.rateLimitSettings, that.rateLimitSettings);
    }

    public int hashCode() {
        return Objects.hash(this.uri, this.modelId, this.rateLimitSettings);
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_15_0;
    }
}

